/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerInteger;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import com.utic.its.asn1.asn1bean.ber.types.string.BerUTF8String;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CurrentLinkState
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 16);
    private byte[] code = null;
    private BerUTF8String linkLinkIdNumber = null;
    private BerInteger linkSpeedRate = null;
    private BerInteger linkVolumeRate = null;
    private BerInteger linkDensityRate = null;
    private BerInteger linkTravelTimeQuantity = null;
    private BerInteger linkDelayQuanity = null;
    private BerInteger tfdtVehicleQueueLengthQuantity = null;
    private BerInteger tfdtOccupancyPercent = null;

    public CurrentLinkState() {
    }

    public CurrentLinkState(byte[] code) {
        this.code = code;
    }

    public void setLinkLinkIdNumber(BerUTF8String linkLinkIdNumber) {
        this.linkLinkIdNumber = linkLinkIdNumber;
    }

    public BerUTF8String getLinkLinkIdNumber() {
        return this.linkLinkIdNumber;
    }

    public void setLinkSpeedRate(BerInteger linkSpeedRate) {
        this.linkSpeedRate = linkSpeedRate;
    }

    public BerInteger getLinkSpeedRate() {
        return this.linkSpeedRate;
    }

    public void setLinkVolumeRate(BerInteger linkVolumeRate) {
        this.linkVolumeRate = linkVolumeRate;
    }

    public BerInteger getLinkVolumeRate() {
        return this.linkVolumeRate;
    }

    public void setLinkDensityRate(BerInteger linkDensityRate) {
        this.linkDensityRate = linkDensityRate;
    }

    public BerInteger getLinkDensityRate() {
        return this.linkDensityRate;
    }

    public void setLinkTravelTimeQuantity(BerInteger linkTravelTimeQuantity) {
        this.linkTravelTimeQuantity = linkTravelTimeQuantity;
    }

    public BerInteger getLinkTravelTimeQuantity() {
        return this.linkTravelTimeQuantity;
    }

    public void setLinkDelayQuanity(BerInteger linkDelayQuanity) {
        this.linkDelayQuanity = linkDelayQuanity;
    }

    public BerInteger getLinkDelayQuanity() {
        return this.linkDelayQuanity;
    }

    public void setTfdtVehicleQueueLengthQuantity(BerInteger tfdtVehicleQueueLengthQuantity) {
        this.tfdtVehicleQueueLengthQuantity = tfdtVehicleQueueLengthQuantity;
    }

    public BerInteger getTfdtVehicleQueueLengthQuantity() {
        return this.tfdtVehicleQueueLengthQuantity;
    }

    public void setTfdtOccupancyPercent(BerInteger tfdtOccupancyPercent) {
        this.tfdtOccupancyPercent = tfdtOccupancyPercent;
    }

    public BerInteger getTfdtOccupancyPercent() {
        return this.tfdtOccupancyPercent;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.tfdtOccupancyPercent.encode(reverseOS, false);
        reverseOS.write(135);
        ++codeLength;
        if (this.tfdtVehicleQueueLengthQuantity != null) {
            codeLength += this.tfdtVehicleQueueLengthQuantity.encode(reverseOS, false);
            reverseOS.write(134);
            ++codeLength;
        }
        if (this.linkDelayQuanity != null) {
            codeLength += this.linkDelayQuanity.encode(reverseOS, false);
            reverseOS.write(133);
            ++codeLength;
        }
        if (this.linkTravelTimeQuantity != null) {
            codeLength += this.linkTravelTimeQuantity.encode(reverseOS, false);
            reverseOS.write(132);
            ++codeLength;
        }
        if (this.linkDensityRate != null) {
            codeLength += this.linkDensityRate.encode(reverseOS, false);
            reverseOS.write(131);
            ++codeLength;
        }
        if (this.linkVolumeRate != null) {
            codeLength += this.linkVolumeRate.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
        }
        codeLength += this.linkSpeedRate.encode(reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        codeLength += this.linkLinkIdNumber.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.linkLinkIdNumber = new BerUTF8String();
            vByteCount += this.linkLinkIdNumber.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 1)) {
            this.linkSpeedRate = new BerInteger();
            vByteCount += this.linkSpeedRate.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.linkVolumeRate = new BerInteger();
            vByteCount += this.linkVolumeRate.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 3)) {
            this.linkDensityRate = new BerInteger();
            vByteCount += this.linkDensityRate.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 4)) {
            this.linkTravelTimeQuantity = new BerInteger();
            vByteCount += this.linkTravelTimeQuantity.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 5)) {
            this.linkDelayQuanity = new BerInteger();
            vByteCount += this.linkDelayQuanity.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 6)) {
            this.tfdtVehicleQueueLengthQuantity = new BerInteger();
            vByteCount += this.tfdtVehicleQueueLengthQuantity.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 7)) {
            this.tfdtOccupancyPercent = new BerInteger();
            if (lengthVal >= 0 && (vByteCount += this.tfdtOccupancyPercent.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.linkLinkIdNumber != null) {
            sb.append("linkLinkIdNumber: ").append(this.linkLinkIdNumber);
        } else {
            sb.append("linkLinkIdNumber: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.linkSpeedRate != null) {
            sb.append("linkSpeedRate: ").append(this.linkSpeedRate);
        } else {
            sb.append("linkSpeedRate: <empty-required-field>");
        }
        if (this.linkVolumeRate != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("linkVolumeRate: ").append(this.linkVolumeRate);
        }
        if (this.linkDensityRate != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("linkDensityRate: ").append(this.linkDensityRate);
        }
        if (this.linkTravelTimeQuantity != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("linkTravelTimeQuantity: ").append(this.linkTravelTimeQuantity);
        }
        if (this.linkDelayQuanity != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("linkDelayQuanity: ").append(this.linkDelayQuanity);
        }
        if (this.tfdtVehicleQueueLengthQuantity != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("tfdtVehicleQueueLengthQuantity: ").append(this.tfdtVehicleQueueLengthQuantity);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.tfdtOccupancyPercent != null) {
            sb.append("tfdtOccupancyPercent: ").append(this.tfdtOccupancyPercent);
        } else {
            sb.append("tfdtOccupancyPercent: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

