/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerEnum;
import com.utic.its.asn1.asn1bean.ber.types.BerOctetString;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class DatexDataPacket
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 16);
    private byte[] code = null;
    private BerEnum datexVersionNumber = null;
    private BerOctetString datexData = null;
    private BerOctetString datexCrcNbr = null;

    public DatexDataPacket() {
    }

    public DatexDataPacket(byte[] code) {
        this.code = code;
    }

    public void setDatexVersionNumber(BerEnum datexVersionNumber) {
        this.datexVersionNumber = datexVersionNumber;
    }

    public BerEnum getDatexVersionNumber() {
        return this.datexVersionNumber;
    }

    public void setDatexData(BerOctetString datexData) {
        this.datexData = datexData;
    }

    public BerOctetString getDatexData() {
        return this.datexData;
    }

    public void setDatexCrcNbr(BerOctetString datexCrcNbr) {
        this.datexCrcNbr = datexCrcNbr;
    }

    public BerOctetString getDatexCrcNbr() {
        return this.datexCrcNbr;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.datexCrcNbr.encode(reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += this.datexData.encode(reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        codeLength += this.datexVersionNumber.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.datexVersionNumber = new BerEnum();
            vByteCount += this.datexVersionNumber.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 1)) {
            this.datexData = new BerOctetString();
            vByteCount += this.datexData.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.datexCrcNbr = new BerOctetString();
            if (lengthVal >= 0 && (vByteCount += this.datexCrcNbr.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexVersionNumber != null) {
            sb.append("datexVersionNumber: ").append(this.datexVersionNumber);
        } else {
            sb.append("datexVersionNumber: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexData != null) {
            sb.append("datexData: ").append(this.datexData);
        } else {
            sb.append("datexData: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexCrcNbr != null) {
            sb.append("datexCrcNbr: ").append(this.datexCrcNbr);
        } else {
            sb.append("datexCrcNbr: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

