/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerAny;
import com.utic.its.asn1.asn1bean.ber.types.BerObjectIdentifier;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class EndApplicationMessage
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 16);
    private byte[] code = null;
    private BerObjectIdentifier endApplicationMessageId = null;
    private BerAny endApplicationMessageMsg = null;

    public EndApplicationMessage() {
    }

    public EndApplicationMessage(byte[] code) {
        this.code = code;
    }

    public void setEndApplicationMessageId(BerObjectIdentifier endApplicationMessageId) {
        this.endApplicationMessageId = endApplicationMessageId;
    }

    public BerObjectIdentifier getEndApplicationMessageId() {
        return this.endApplicationMessageId;
    }

    public void setEndApplicationMessageMsg(BerAny endApplicationMessageMsg) {
        this.endApplicationMessageMsg = endApplicationMessageMsg;
    }

    public BerAny getEndApplicationMessageMsg() {
        return this.endApplicationMessageMsg;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        int sublength = this.endApplicationMessageMsg.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength(reverseOS, sublength);
        reverseOS.write(161);
        ++codeLength;
        codeLength += this.endApplicationMessageId.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.endApplicationMessageId = new BerObjectIdentifier();
            vByteCount += this.endApplicationMessageId.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 32, 1)) {
            vByteCount += length.decode(is);
            this.endApplicationMessageMsg = new BerAny();
            vByteCount += this.endApplicationMessageMsg.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.endApplicationMessageId != null) {
            sb.append("endApplicationMessageId: ").append(this.endApplicationMessageId);
        } else {
            sb.append("endApplicationMessageId: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.endApplicationMessageMsg != null) {
            sb.append("endApplicationMessageMsg: ").append(this.endApplicationMessageMsg);
        } else {
            sb.append("endApplicationMessageMsg: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

