/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerOctetString;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import com.utic.its.asn1.asn1bean.ber.types.string.BerUTF8String;
import com.utic.its.asn1.its.Cost;
import com.utic.its.asn1.its.Time;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class HeaderOptions
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 16);
    private byte[] code = null;
    private BerUTF8String datexOriginText = null;
    private BerOctetString datexOriginAddressLocation = null;
    private BerUTF8String datexSenderText = null;
    private BerOctetString datexSenderAddressLocation = null;
    private BerUTF8String datexDestinationText = null;
    private BerOctetString datexDestinationAddressLocation = null;
    private Cost datexCost = null;
    private Time datexDataPacketTime = null;

    public HeaderOptions() {
    }

    public HeaderOptions(byte[] code) {
        this.code = code;
    }

    public void setDatexOriginText(BerUTF8String datexOriginText) {
        this.datexOriginText = datexOriginText;
    }

    public BerUTF8String getDatexOriginText() {
        return this.datexOriginText;
    }

    public void setDatexOriginAddressLocation(BerOctetString datexOriginAddressLocation) {
        this.datexOriginAddressLocation = datexOriginAddressLocation;
    }

    public BerOctetString getDatexOriginAddressLocation() {
        return this.datexOriginAddressLocation;
    }

    public void setDatexSenderText(BerUTF8String datexSenderText) {
        this.datexSenderText = datexSenderText;
    }

    public BerUTF8String getDatexSenderText() {
        return this.datexSenderText;
    }

    public void setDatexSenderAddressLocation(BerOctetString datexSenderAddressLocation) {
        this.datexSenderAddressLocation = datexSenderAddressLocation;
    }

    public BerOctetString getDatexSenderAddressLocation() {
        return this.datexSenderAddressLocation;
    }

    public void setDatexDestinationText(BerUTF8String datexDestinationText) {
        this.datexDestinationText = datexDestinationText;
    }

    public BerUTF8String getDatexDestinationText() {
        return this.datexDestinationText;
    }

    public void setDatexDestinationAddressLocation(BerOctetString datexDestinationAddressLocation) {
        this.datexDestinationAddressLocation = datexDestinationAddressLocation;
    }

    public BerOctetString getDatexDestinationAddressLocation() {
        return this.datexDestinationAddressLocation;
    }

    public void setDatexCost(Cost datexCost) {
        this.datexCost = datexCost;
    }

    public Cost getDatexCost() {
        return this.datexCost;
    }

    public void setDatexDataPacketTime(Time datexDataPacketTime) {
        this.datexDataPacketTime = datexDataPacketTime;
    }

    public Time getDatexDataPacketTime() {
        return this.datexDataPacketTime;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.datexDataPacketTime != null) {
            codeLength += this.datexDataPacketTime.encode(reverseOS, false);
            reverseOS.write(167);
            ++codeLength;
        }
        if (this.datexCost != null) {
            codeLength += this.datexCost.encode(reverseOS, false);
            reverseOS.write(166);
            ++codeLength;
        }
        if (this.datexDestinationAddressLocation != null) {
            codeLength += this.datexDestinationAddressLocation.encode(reverseOS, false);
            reverseOS.write(133);
            ++codeLength;
        }
        if (this.datexDestinationText != null) {
            codeLength += this.datexDestinationText.encode(reverseOS, false);
            reverseOS.write(132);
            ++codeLength;
        }
        if (this.datexSenderAddressLocation != null) {
            codeLength += this.datexSenderAddressLocation.encode(reverseOS, false);
            reverseOS.write(131);
            ++codeLength;
        }
        if (this.datexSenderText != null) {
            codeLength += this.datexSenderText.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
        }
        if (this.datexOriginAddressLocation != null) {
            codeLength += this.datexOriginAddressLocation.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
        }
        if (this.datexOriginText != null) {
            codeLength += this.datexOriginText.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        if (lengthVal == 0) {
            return tlByteCount;
        }
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.datexOriginText = new BerUTF8String();
            if (lengthVal >= 0 && (vByteCount += this.datexOriginText.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 1)) {
            this.datexOriginAddressLocation = new BerOctetString();
            if (lengthVal >= 0 && (vByteCount += this.datexOriginAddressLocation.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 2)) {
            this.datexSenderText = new BerUTF8String();
            if (lengthVal >= 0 && (vByteCount += this.datexSenderText.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 3)) {
            this.datexSenderAddressLocation = new BerOctetString();
            if (lengthVal >= 0 && (vByteCount += this.datexSenderAddressLocation.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 4)) {
            this.datexDestinationText = new BerUTF8String();
            if (lengthVal >= 0 && (vByteCount += this.datexDestinationText.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 5)) {
            this.datexDestinationAddressLocation = new BerOctetString();
            if (lengthVal >= 0 && (vByteCount += this.datexDestinationAddressLocation.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 6)) {
            this.datexCost = new Cost();
            if (lengthVal >= 0 && (vByteCount += this.datexCost.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 7)) {
            this.datexDataPacketTime = new Time();
            if (lengthVal >= 0 && (vByteCount += this.datexDataPacketTime.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.datexOriginText != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexOriginText: ").append(this.datexOriginText);
            firstSelectedElement = false;
        }
        if (this.datexOriginAddressLocation != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexOriginAddressLocation: ").append(this.datexOriginAddressLocation);
            firstSelectedElement = false;
        }
        if (this.datexSenderText != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexSenderText: ").append(this.datexSenderText);
            firstSelectedElement = false;
        }
        if (this.datexSenderAddressLocation != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexSenderAddressLocation: ").append(this.datexSenderAddressLocation);
            firstSelectedElement = false;
        }
        if (this.datexDestinationText != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexDestinationText: ").append(this.datexDestinationText);
            firstSelectedElement = false;
        }
        if (this.datexDestinationAddressLocation != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexDestinationAddressLocation: ").append(this.datexDestinationAddressLocation);
            firstSelectedElement = false;
        }
        if (this.datexCost != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexCost: ");
            this.datexCost.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        if (this.datexDataPacketTime != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("datexDataPacketTime: ");
            this.datexDataPacketTime.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

