/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerBoolean;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import com.utic.its.asn1.its.PublishFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Publication
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 16);
    private byte[] code = null;
    private BerBoolean datexPublishGuaranteedBool = null;
    private PublishFormat datexPublishFormat = null;

    public Publication() {
    }

    public Publication(byte[] code) {
        this.code = code;
    }

    public void setDatexPublishGuaranteedBool(BerBoolean datexPublishGuaranteedBool) {
        this.datexPublishGuaranteedBool = datexPublishGuaranteedBool;
    }

    public BerBoolean getDatexPublishGuaranteedBool() {
        return this.datexPublishGuaranteedBool;
    }

    public void setDatexPublishFormat(PublishFormat datexPublishFormat) {
        this.datexPublishFormat = datexPublishFormat;
    }

    public PublishFormat getDatexPublishFormat() {
        return this.datexPublishFormat;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        int sublength = this.datexPublishFormat.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength(reverseOS, sublength);
        reverseOS.write(161);
        ++codeLength;
        codeLength += this.datexPublishGuaranteedBool.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.datexPublishGuaranteedBool = new BerBoolean();
            vByteCount += this.datexPublishGuaranteedBool.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 32, 1)) {
            vByteCount += length.decode(is);
            this.datexPublishFormat = new PublishFormat();
            vByteCount += this.datexPublishFormat.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexPublishGuaranteedBool != null) {
            sb.append("datexPublishGuaranteedBool: ").append(this.datexPublishGuaranteedBool);
        } else {
            sb.append("datexPublishGuaranteedBool: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexPublishFormat != null) {
            sb.append("datexPublishFormat: ");
            this.datexPublishFormat.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("datexPublishFormat: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

