/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerNull;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import com.utic.its.asn1.its.Registered;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SubscriptionMode
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private BerNull single = null;
    private Registered eventDriven = null;
    private Registered periodic = null;

    public SubscriptionMode() {
    }

    public SubscriptionMode(byte[] code) {
        this.code = code;
    }

    public void setSingle(BerNull single) {
        this.single = single;
    }

    public BerNull getSingle() {
        return this.single;
    }

    public void setEventDriven(Registered eventDriven) {
        this.eventDriven = eventDriven;
    }

    public Registered getEventDriven() {
        return this.eventDriven;
    }

    public void setPeriodic(Registered periodic) {
        this.periodic = periodic;
    }

    public Registered getPeriodic() {
        return this.periodic;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.periodic != null) {
            int sublength = this.periodic.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength(reverseOS, sublength);
            reverseOS.write(162);
            return ++codeLength;
        }
        if (this.eventDriven != null) {
            int sublength = this.eventDriven.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength(reverseOS, sublength);
            reverseOS.write(161);
            return ++codeLength;
        }
        if (this.single != null) {
            codeLength += this.single.encode(reverseOS, false);
            reverseOS.write(128);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 0)) {
            this.single = new BerNull();
            return tlvByteCount += this.single.decode(is, false);
        }
        if (berTag.equals(128, 32, 1)) {
            BerLength length = new BerLength();
            tlvByteCount += length.decode(is);
            this.eventDriven = new Registered();
            tlvByteCount += this.eventDriven.decode(is, null);
            return tlvByteCount += length.readEocIfIndefinite(is);
        }
        if (berTag.equals(128, 32, 2)) {
            BerLength length = new BerLength();
            tlvByteCount += length.decode(is);
            this.periodic = new Registered();
            tlvByteCount += this.periodic.decode(is, null);
            return tlvByteCount += length.readEocIfIndefinite(is);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.single != null) {
            sb.append("single: ").append(this.single);
            return;
        }
        if (this.eventDriven != null) {
            sb.append("eventDriven: ");
            this.eventDriven.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.periodic != null) {
            sb.append("periodic: ");
            this.periodic.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

