/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.utils;

import com.utic.its.asn1.asn1bean.ber.types.BerGeneralizedTime;
import com.utic.its.asn1.asn1bean.ber.types.BerInteger;
import com.utic.its.asn1.asn1bean.ber.types.BerOctetString;
import com.utic.its.asn1.asn1bean.ber.types.string.BerUTF8String;
import com.utic.its.asn1.enums.ePdusPr;
import com.utic.its.asn1.its.HeaderOptions;
import com.utic.its.asn1.its.PDUs;
import com.utic.its.asn1.its.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItsAsnUtils {
    private static final Logger log = LoggerFactory.getLogger(ItsAsnUtils.class);

    private ItsAsnUtils() {
    }

    public static Time getTime() {
        Time tm = new Time();
        Time.TimeSecondFractions tmFac = new Time.TimeSecondFractions();
        Time.TimeTimezone tmZon = new Time.TimeTimezone();
        Calendar currTm = Calendar.getInstance();
        tm.setTimeYearQty(new BerInteger(currTm.get(1)));
        tm.setTimeMonthQty(new BerInteger(currTm.get(2) + 1));
        tm.setTimeDayQty(new BerInteger(currTm.get(5)));
        tm.setTimeHourQty(new BerInteger(currTm.get(11)));
        tm.setTimeMinuteQty(new BerInteger(currTm.get(12)));
        tm.setTimeSecondQty(new BerInteger(currTm.get(13)));
        tmFac.setMilliseconds(new BerInteger(currTm.get(14)));
        tm.setTimeSecondFractions(tmFac);
        tmZon.setTimezoneHourQty(new BerInteger(9L));
        tmZon.setTimeMinuteQty(new BerInteger(0L));
        tm.setTimeTimezone(tmZon);
        return tm;
    }

    public static Time getRegisterStartTime() {
        LocalDateTime now = LocalDateTime.now();
        Time tm = new Time();
        Time.TimeSecondFractions tmSecond = new Time.TimeSecondFractions();
        tmSecond.setDeciSeconds(new BerInteger(0L));
        Time.TimeTimezone tmZone = new Time.TimeTimezone();
        tmZone.setTimezoneHourQty(new BerInteger(9L));
        tmZone.setTimeMinuteQty(new BerInteger(0L));
        tm.setTimeYearQty(new BerInteger(now.getYear()));
        tm.setTimeMonthQty(new BerInteger(now.getMonthValue()));
        tm.setTimeDayQty(new BerInteger(now.getDayOfMonth()));
        tm.setTimeHourQty(new BerInteger(now.getHour()));
        tm.setTimeMinuteQty(new BerInteger(now.getMinute()));
        tm.setTimeSecondQty(new BerInteger(0L));
        tm.setTimeSecondFractions(tmSecond);
        tm.setTimeTimezone(tmZone);
        return tm;
    }

    public static Time getRegisterEndTime() {
        LocalDateTime now = LocalDateTime.now();
        Time tm = new Time();
        Time.TimeSecondFractions tmSecond = new Time.TimeSecondFractions();
        tmSecond.setDeciSeconds(new BerInteger(0L));
        Time.TimeTimezone tmZone = new Time.TimeTimezone();
        tmZone.setTimezoneHourQty(new BerInteger(9L));
        tmZone.setTimeMinuteQty(new BerInteger(0L));
        tm.setTimeYearQty(new BerInteger(now.getYear() + 10));
        tm.setTimeMonthQty(new BerInteger(now.getMonthValue()));
        tm.setTimeDayQty(new BerInteger(now.getDayOfMonth()));
        tm.setTimeHourQty(new BerInteger(now.getHour()));
        tm.setTimeMinuteQty(new BerInteger(now.getMinute()));
        tm.setTimeSecondQty(new BerInteger(0L));
        tm.setTimeSecondFractions(tmSecond);
        tm.setTimeTimezone(tmZone);
        return tm;
    }

    public static HeaderOptions getHeaderOptions(BerUTF8String senderText, BerUTF8String localIpAddress, BerUTF8String remoteText, BerOctetString remoteIpAddress) {
        HeaderOptions hdrOpts = new HeaderOptions();
        hdrOpts.setDatexOriginText(senderText);
        hdrOpts.setDatexOriginAddressLocation(localIpAddress);
        hdrOpts.setDatexSenderText(senderText);
        hdrOpts.setDatexSenderAddressLocation(localIpAddress);
        hdrOpts.setDatexDestinationText(remoteText);
        hdrOpts.setDatexDestinationAddressLocation(remoteIpAddress);
        hdrOpts.setDatexDataPacketTime(ItsAsnUtils.getTime());
        return hdrOpts;
    }

    public static HeaderOptions getDefaultOptions() {
        HeaderOptions hdrOpts = ItsAsnUtils.getHeaderOptions(new BerUTF8String("UTIC Center Unit"), new BerUTF8String("UTIC Center Unit"), new BerUTF8String("UTIC Main Control Unit"), new BerUTF8String("UTIC Main Control Unit"));
        return hdrOpts;
    }

    public static HeaderOptions swapHeaderOptions(HeaderOptions options) {
        HeaderOptions hdrOpts = new HeaderOptions();
        hdrOpts.setDatexOriginText(options.getDatexDestinationText());
        hdrOpts.setDatexOriginAddressLocation(options.getDatexDestinationAddressLocation());
        hdrOpts.setDatexSenderText(options.getDatexDestinationText());
        hdrOpts.setDatexSenderAddressLocation(options.getDatexDestinationAddressLocation());
        hdrOpts.setDatexDestinationText(options.getDatexSenderText());
        hdrOpts.setDatexDestinationAddressLocation(options.getDatexSenderAddressLocation());
        hdrOpts.setDatexDataPacketTime(ItsAsnUtils.getTime());
        return hdrOpts;
    }

    public static String getSysTime() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMddHHmmss");
        Date dtLog = new Date();
        return sdfDate.format(dtLog);
    }

    public static BerGeneralizedTime getBerGeneralizedTime() {
        return new BerGeneralizedTime(ItsAsnUtils.getSysTime());
    }

    public static ePdusPr getPduChoice(PDUs pdus) {
        if (pdus.getLogin() != null) {
            return ePdusPr.PDUs_PR_login;
        }
        if (pdus.getFred() != null) {
            return ePdusPr.PDUs_PR_fred;
        }
        if (pdus.getSubscription() != null) {
            return ePdusPr.PDUs_PR_subscripiton;
        }
        if (pdus.getAccept() != null) {
            return ePdusPr.PDUs_PR_accept;
        }
        if (pdus.getPublication() != null) {
            return ePdusPr.PDUs_PR_publication;
        }
        if (pdus.getTransferDone() != null) {
            return ePdusPr.PDUs_PR_transfer_done;
        }
        if (pdus.getDatexInitiateNull() != null) {
            return ePdusPr.PDUs_PR_datex_Initiate_null;
        }
        if (pdus.getLogout() != null) {
            return ePdusPr.PDUs_PR_logout;
        }
        if (pdus.getTerminate() != null) {
            return ePdusPr.PDUs_PR_terminate;
        }
        if (pdus.getReject() != null) {
            return ePdusPr.PDUs_PR_reject;
        }
        return ePdusPr.PDUs_PR_NOTHING;
    }

    public static int getPduChoiceId(PDUs pdus) {
        if (pdus.getLogin() != null) {
            return ePdusPr.PDUs_PR_login.getValue();
        }
        if (pdus.getFred() != null) {
            return ePdusPr.PDUs_PR_fred.getValue();
        }
        if (pdus.getSubscription() != null) {
            return ePdusPr.PDUs_PR_subscripiton.getValue();
        }
        if (pdus.getAccept() != null) {
            return ePdusPr.PDUs_PR_accept.getValue();
        }
        if (pdus.getPublication() != null) {
            return ePdusPr.PDUs_PR_publication.getValue();
        }
        if (pdus.getTransferDone() != null) {
            return ePdusPr.PDUs_PR_transfer_done.getValue();
        }
        if (pdus.getDatexInitiateNull() != null) {
            return ePdusPr.PDUs_PR_datex_Initiate_null.getValue();
        }
        if (pdus.getLogout() != null) {
            return ePdusPr.PDUs_PR_logout.getValue();
        }
        if (pdus.getTerminate() != null) {
            return ePdusPr.PDUs_PR_terminate.getValue();
        }
        if (pdus.getReject() != null) {
            return ePdusPr.PDUs_PR_reject.getValue();
        }
        return ePdusPr.PDUs_PR_NOTHING.getValue();
    }

    public static int getObjectId(int[] endApplicationMessageId) {
        return endApplicationMessageId[endApplicationMessageId.length - 3] * 100 + endApplicationMessageId[endApplicationMessageId.length - 2] * 10 + endApplicationMessageId[endApplicationMessageId.length - 1];
    }
}

