/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.aspect;

import com.its.vds.stat.server.annotation.SqlOperation;
import com.its.vds.stat.server.aspect.AbstractLoggingAspect;
import com.its.vds.stat.server.utils.LogUtils;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SqlOperationAspect
extends AbstractLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(SqlOperationAspect.class);

    protected String typeString(String type) {
        int targetLength = 8;
        if (type.length() >= 8) {
            return type;
        }
        return this.padEnd(type, 8, ' ');
    }

    @Around(value="@annotation(com.its.vds.stat.server.annotation.SqlOperation)")
    public Object aspectSqlOperation(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        SqlOperation sqlOperation = signature.getMethod().getAnnotation(SqlOperation.class);
        String param = sqlOperation.param();
        String param2 = sqlOperation.param2();
        Object[] args = joinPoint.getArgs();
        boolean isLogging = sqlOperation.logging();
        String type = sqlOperation.type().getShortName();
        String tableName = sqlOperation.table();
        String paramValue = null;
        String paramValue2 = null;
        String[] paramNames = signature.getParameterNames();
        for (int ii = 0; ii < paramNames.length; ++ii) {
            if (!Objects.equals(param, "") && paramNames[ii].equalsIgnoreCase(param)) {
                paramValue = String.valueOf(args[ii]);
            }
            if (Objects.equals(param, "") || Objects.equals(param2, "") || !paramNames[ii].equalsIgnoreCase(param2)) continue;
            paramValue2 = String.valueOf(args[ii]);
        }
        long start = System.currentTimeMillis();
        try {
            result = joinPoint.proceed();
        }
        catch (Exception e) {
            long executionTime = System.currentTimeMillis() - start;
            log.error("({}) {}: Exception: {}", new Object[]{type, LogUtils.elapsedLog((String)tableName, (long)executionTime), e.getMessage()});
            if (signature.getReturnType().equals(Integer.TYPE)) {
                return -1;
            }
            if (Objects.requireNonNull(sqlOperation.type()) == SqlOperation.SqlType.SELECT) {
                return null;
            }
            return -1;
        }
        long executionTime = System.currentTimeMillis() - start;
        int count = 1;
        if (signature.getReturnType().equals(Integer.TYPE)) {
            count = (Integer)result;
        } else if (signature.getReturnType().equals(List.class)) {
            List list = (List)result;
            count = list.size();
        }
        if (!Objects.equals(param, "") && paramValue == null) {
            paramValue = param;
        }
        if (isLogging) {
            String info = Objects.requireNonNull(sqlOperation.type()) == SqlOperation.SqlType.TRUNCATE ? LogUtils.elapsedLog((String)tableName, (long)executionTime) : LogUtils.elapsedLog((String)tableName, (int)count, (long)executionTime);
            this.logging(type, info, paramValue, paramValue2);
        }
        return result;
    }

    private void logging(String type, String info, String paramValue, String paramValue2) {
        if (paramValue != null) {
            if (paramValue2 != null) {
                log.info("({}) {}, {}, {}", new Object[]{type, info, paramValue, paramValue2});
            } else {
                log.info("({}) {}, {}", new Object[]{type, info, paramValue});
            }
        } else {
            log.info("({}) {}", (Object)type, (Object)info);
        }
    }
}

