/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.controller;

import com.its.vds.stat.server.service.VdsStatServerService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class VdsStatBatchServerController {
    private static final Logger log = LoggerFactory.getLogger(VdsStatBatchServerController.class);
    private final VdsStatServerService service;

    public void run(String startDtStr, String endDtStr) {
        log.info("Start Batch Job: {} ~ {}", (Object)startDtStr, (Object)endDtStr);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime start = LocalDateTime.parse(startDtStr, formatter);
        LocalDateTime end = LocalDateTime.parse(endDtStr, formatter);
        while (!start.isAfter(end)) {
            String startStr = start.format(formatter);
            String plus5Str = start.plusMinutes(5L).format(formatter);
            String plus5Minus1Str = start.plusMinutes(5L).minusSeconds(1L).format(formatter);
            log.info("------------------------------------------------------------");
            log.info("05MIN: {}, {}", (Object)startStr, (Object)plus5Minus1Str);
            int hour = start.getHour();
            int minute = start.getMinute();
            int day = start.getDayOfMonth();
            int month = start.getMonthValue();
            int result = 0;
            String start05MinFrom = start.plusMinutes(-5L).format(formatter);
            String start05MinTo = start.minusSeconds(1L).format(formatter);
            this.service.delVdsDtctHs(start05MinFrom);
            result = this.service.crtVdsDtctHs(start05MinFrom, start05MinFrom, start05MinTo);
            log.info(" 5MIN: {}, {}, {} EA.", new Object[]{start05MinFrom, start05MinTo, result});
            if (minute % 15 == 0) {
                String start15MinFrom = start.plusMinutes(-15L).format(formatter);
                String start15MinTo = start.minusSeconds(1L).format(formatter);
                this.service.delVdsDtct15MinStat(start05MinFrom);
                result = this.service.crtVdsDtct15MinStat(start15MinFrom, start15MinFrom, start15MinTo);
                log.info("15MIN: {}, {}, {} EA.", new Object[]{start15MinFrom, start15MinTo, result});
            }
            if (minute == 0) {
                String startHourFrom = start.plusMinutes(-60L).format(formatter);
                String startHourTo = start.minusSeconds(1L).format(formatter);
                this.service.delVdsDtctHhStat(startHourFrom);
                result = this.service.crtVdsDtctHhStat(startHourFrom, startHourFrom, startHourTo);
                log.info(" HOUR: {}, {}, {} EA.", new Object[]{startHourFrom, startHourTo, result});
            }
            if (hour == 0 && minute == 0) {
                String startDayFrom = start.minusDays(1L).format(formatter);
                String startDayTo = start.minusSeconds(1L).format(formatter);
                this.service.delVdsDtctDdStat(startDayFrom);
                result = this.service.crtVdsDtctDdStat(startDayFrom, startDayFrom, startDayTo);
                log.info("  DAY: {}, {}, {} EA.", new Object[]{startDayFrom, startDayTo, result});
                String startMonthFrom = start.minusMonths(1L).withDayOfMonth(1).format(formatter);
                String startMonthTo = start.minusSeconds(1L).format(formatter);
                result = this.service.crtVdsDtctMnStat(startMonthFrom, startMonthFrom, startMonthTo);
                log.info("MONTH: {}, {}, {} EA.", new Object[]{startMonthFrom, startMonthTo, result});
            }
            start = start.plusMinutes(5L);
        }
        log.info("=========================================================");
    }

    public VdsStatBatchServerController(VdsStatServerService service) {
        this.service = service;
    }
}

