/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.controller;

import com.its.vds.stat.server.controller.VdsStatServerRestController;
import com.its.vds.stat.server.service.VdsStatServerService;
import com.its.vds.stat.server.utils.LogUtils;
import com.its.vds.stat.server.utils.StatisticsTime;
import com.its.vds.stat.server.utils.TimeUtils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class VdsStatServerController {
    private static final Logger log = LoggerFactory.getLogger(VdsStatServerController.class);
    private final MeterRegistry meterRegistry;
    private final VdsStatServerRestController restController;
    private final VdsStatServerService service;
    private final StatisticsTime its = new StatisticsTime();
    private boolean is05Min = false;
    private String prevPrcsTime;
    private Timer min05Timer;
    private Counter min05Counter;
    private Timer min15Timer;
    private Counter min15Counter;
    private Timer hourTimer;
    private Counter hourCounter;
    private Timer monthTimer;
    private Counter dayCounter;
    private Timer dayTimer;
    private Counter monthCounter;
    private Timer yearTimer;
    private Counter yearCounter;

    @PostConstruct
    void init() {
        this.min05Timer = Timer.builder((String)"vds_stat_05min_execution_time").description("Execution time for 5min VDS stats").register(this.meterRegistry);
        this.min05Counter = Counter.builder((String)"vds_stat_05min_count").description("Processed records for 5min VDS stats").register(this.meterRegistry);
        this.min15Timer = Timer.builder((String)"vds_stat_15min_execution_time").description("Execution time for 15min VDS stats").register(this.meterRegistry);
        this.min15Counter = Counter.builder((String)"vds_stat_15min_count").description("Processed records for 15min VDS stats").register(this.meterRegistry);
        this.hourTimer = Timer.builder((String)"vds_stat_hour_execution_time").description("Execution time for hour VDS stats").register(this.meterRegistry);
        this.hourCounter = Counter.builder((String)"vds_stat_hour_count").description("Processed records for hour VDS stats").register(this.meterRegistry);
        this.dayTimer = Timer.builder((String)"vds_stat_day_execution_time").description("Execution time for day VDS stats").register(this.meterRegistry);
        this.dayCounter = Counter.builder((String)"vds_stat_day_count").description("Processed records for day VDS stats").register(this.meterRegistry);
        this.monthTimer = Timer.builder((String)"vds_stat_month_execution_time").description("Execution time for month VDS stats").register(this.meterRegistry);
        this.monthCounter = Counter.builder((String)"vds_stat_month_count").description("Processed records for month VDS stats").register(this.meterRegistry);
        this.yearTimer = Timer.builder((String)"vds_stat_year_execution_time").description("Execution time for year VDS stats").register(this.meterRegistry);
        this.yearCounter = Counter.builder((String)"vds_stat_year_count").description("Processed records for year VDS stats").register(this.meterRegistry);
    }

    private void calculateTime() {
        LocalDateTime now = LocalDateTime.now();
        int minute = now.getMinute();
        this.is05Min = minute % 5 == 0;
    }

    public boolean run() {
        int result;
        Integer recordResult;
        String header = "==========================================================================================================";
        String step = "----------------------------------------------------------------------------------------------------------";
        String completed = "**********************************************************************************************************";
        long start = System.currentTimeMillis();
        this.calculateTime();
        if (!this.is05Min) {
            return false;
        }
        log.info("==========================================================================================================");
        if (this.its.IsProcessing()) {
            log.warn("[WAN] {}: [{}] - Already running.", (Object)LogUtils.elapsedLog((String)"Overlapping"), (Object)this.prevPrcsTime);
        }
        this.prevPrcsTime = TimeUtils.getCurrentTimeString();
        this.its.init();
        this.its.setProcessing(true);
        if (this.is05Min) {
            recordResult = (Integer)this.min05Timer.record(() -> this.service.crtVdsDtctHs(this.its.getPrcsFiveMin(), this.its.getPrcsFiveMinFrom(), this.its.getPrcsFiveMinTo()));
            result = recordResult != null ? recordResult : -1;
            this.min05Counter.increment((double)result);
            this.restController.addMin05Hs(this.prevPrcsTime, this.its.getPrcsFiveMin(), this.its.getPrcsFiveMinFrom(), this.its.getPrcsFiveMinTo(), result);
            log.info("crtVdsDtctHs: {} EA.", (Object)result);
            log.info("----------------------------------------------------------------------------------------------------------");
        }
        log.info("##>> 05MIN {}: [{}]", (Object)LogUtils.elapsedLogLength((String)"\uc815\uc8fc\uae30 VDS \ud1b5\uacc4 Start", (int)5), (Object)this.prevPrcsTime);
        if (this.its.isStat15Min()) {
            recordResult = (Integer)this.min15Timer.record(() -> this.service.crtVdsDtct15MinStat(this.its.getStat15MinFrom(), this.its.getStat15MinFrom(), this.its.getStat15MinTo()));
            result = recordResult != null ? recordResult : -1;
            this.min15Counter.increment((double)result);
            this.restController.addMin15Hs(this.prevPrcsTime, this.its.getStat15MinFrom(), this.its.getStat15MinFrom(), this.its.getStat15MinTo(), result);
            log.info("crtVdsDtct15MinStat: {} EA.", (Object)result);
            log.info("----------------------------------------------------------------------------------------------------------");
        }
        if (this.its.isStatHour()) {
            recordResult = (Integer)this.hourTimer.record(() -> this.service.crtVdsDtctHhStat(this.its.getStatHourTime(), this.its.getStatHourTime(), this.its.getStatHourTo()));
            result = recordResult != null ? recordResult : -1;
            this.hourCounter.increment((double)result);
            this.restController.addHourHs(this.prevPrcsTime, this.its.getStatHourTime(), this.its.getStatHourTime(), this.its.getStatHourTo(), result);
            log.info("crtVdsDtctHhStat: {} EA.", (Object)result);
            log.info("----------------------------------------------------------------------------------------------------------");
        }
        if (this.its.isStatDay()) {
            recordResult = (Integer)this.dayTimer.record(() -> this.service.crtVdsDtctDdStat(this.its.getStatDayFrom(), this.its.getStatDayFrom(), this.its.getStatDayTo()));
            result = recordResult != null ? recordResult : -1;
            this.dayCounter.increment((double)result);
            this.restController.addDayHs(this.prevPrcsTime, this.its.getStatDayFrom(), this.its.getStatDayFrom(), this.its.getStatDayTo(), result);
            log.info("crtVdsDtctDdStat: {} EA.", (Object)result);
            log.info("----------------------------------------------------------------------------------------------------------");
        }
        if (this.its.isStatMon()) {
            String statMon = this.its.getStatMonFrom().substring(0, 6) + "00000000";
            recordResult = (Integer)this.monthTimer.record(() -> this.service.crtVdsDtctMnStat(statMon, this.its.getStatMonFrom(), this.its.getStatMonTo()));
            result = recordResult != null ? recordResult : -1;
            this.monthCounter.increment((double)result);
            this.restController.addMonthHs(this.prevPrcsTime, statMon, this.its.getStatMonFrom(), this.its.getStatMonTo(), result);
            log.info("crtVdsDtctMnStat: {} EA.", (Object)result);
            log.info("----------------------------------------------------------------------------------------------------------");
        }
        if (this.its.isStatYear()) {
            String statYear = this.its.getStatYearFrom().substring(0, 4) + "0000000000";
            recordResult = (Integer)this.yearTimer.record(() -> this.service.crtVdsDtctYyStat(statYear, this.its.getStatYearFrom(), this.its.getStatYearTo()));
            result = recordResult != null ? recordResult : -1;
            this.yearCounter.increment((double)result);
            this.restController.addYearHs(this.prevPrcsTime, statYear, this.its.getStatYearFrom(), this.its.getStatYearTo(), result);
            log.info("crtVdsDtctYyStat: {} EA.", (Object)result);
            log.info("----------------------------------------------------------------------------------------------------------");
        }
        this.its.setProcessing(false);
        long executionTime = System.currentTimeMillis() - start;
        log.info("<<## 05MIN {} [{}].", (Object)LogUtils.elapsedLogLength((String)"\uc815\uc8fc\uae30 VDS \ud1b5\uacc4 End", (long)executionTime, (int)5), (Object)this.prevPrcsTime);
        log.info("**********************************************************************************************************");
        return true;
    }

    public VdsStatServerController(MeterRegistry meterRegistry, VdsStatServerRestController restController, VdsStatServerService service) {
        this.meterRegistry = meterRegistry;
        this.restController = restController;
        this.service = service;
    }
}

