/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.aspect;

import com.its.vds.stat.server.annotation.ProcessingElapsed;
import com.its.vds.stat.server.aspect.AbstractLoggingAspect;
import com.its.vds.stat.server.utils.LogUtils;
import com.its.vds.stat.server.utils.TimeUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LoggingAspect
extends AbstractLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(LoggingAspect.class);

    @Around(value="@annotation(com.its.vds.stat.server.annotation.ProcessingElapsed)")
    public Object aspectProcessingElapsedTime(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        ProcessingElapsed annotation = signature.getMethod().getAnnotation(ProcessingElapsed.class);
        String type = annotation.type();
        String processName = annotation.name();
        if (annotation.starting()) {
            log.info("**>> {} {}: [{}]", new Object[]{type, LogUtils.elapsedLogLength((String)(processName + " Start"), (int)type.length()), TimeUtils.getCurrentTimeString()});
        }
        try {
            long start = System.currentTimeMillis();
            Object proceed = joinPoint.proceed();
            long executionTime = System.currentTimeMillis() - start;
            if (annotation.ending()) {
                log.info("<<** {} {}", (Object)type, (Object)LogUtils.elapsedLogLength((String)(processName + " End"), (long)executionTime, (int)type.length()));
            }
            return proceed;
        }
        catch (InterruptedException e) {
            log.error("aspectProcessingElapsedTime: Thread interrupted", (Throwable)e);
            throw e;
        }
    }
}

