/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.config;

import com.its.vds.stat.server.utils.SysUtils;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="application")
public class ApplicationConfig {
    private String bootingTime;
    private boolean startSchedule;
    private String processId = "VDSSTAT";
    private String processName = "VDS STAT Server";

    @PostConstruct
    private void init() {
        this.startSchedule = false;
        this.bootingTime = SysUtils.getSysTimeStr();
    }

    public String getBootingTime() {
        return this.bootingTime;
    }

    public boolean isStartSchedule() {
        return this.startSchedule;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setBootingTime(String bootingTime) {
        this.bootingTime = bootingTime;
    }

    public void setStartSchedule(boolean startSchedule) {
        this.startSchedule = startSchedule;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String toString() {
        return "ApplicationConfig(bootingTime=" + this.getBootingTime() + ", startSchedule=" + this.isStartSchedule() + ", processId=" + this.getProcessId() + ", processName=" + this.getProcessName() + ")";
    }
}

