/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.scheduler;

import com.its.vds.stat.server.config.ApplicationConfig;
import com.its.vds.stat.server.controller.VdsStatServerController;
import com.its.vds.stat.server.service.UnitSystService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class ApplicationScheduler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationScheduler.class);
    private final ApplicationConfig config;
    private final UnitSystService unitSystService;
    private final VdsStatServerController controller;

    @Scheduled(cron="40 * * * * *")
    public void scheduleProcess() {
        if (this.config.isStartSchedule()) {
            try {
                this.unitSystService.processRunning();
            }
            catch (Exception e) {
                log.error("ApplicationScheduler.updateProcessState: Exception {}", (Object)e.getMessage());
            }
            try {
                if (this.controller.run()) {
                    this.unitSystService.processRunning();
                }
            }
            catch (Exception e) {
                log.error("ApplicationScheduler.scheduleProcess: Exception {}", (Object)e.getMessage());
            }
        }
    }

    public ApplicationScheduler(ApplicationConfig config, UnitSystService unitSystService, VdsStatServerController controller) {
        this.config = config;
        this.unitSystService = unitSystService;
        this.controller = controller;
    }
}

