/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.service;

import com.its.vds.stat.server.config.ApplicationConfig;
import com.its.vds.stat.server.dao.repository.UnitSystRepository;
import com.its.vds.stat.server.dto.UnitSystSttsDto;
import com.its.vds.stat.server.utils.SysUtils;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class UnitSystService {
    private static final Logger log = LoggerFactory.getLogger(UnitSystService.class);
    private final ApplicationConfig config;
    private final UnitSystRepository repo;
    private final UnitSystSttsDto unitSystStts = new UnitSystSttsDto();
    private int historyMin = -1;

    @PostConstruct
    private void init() {
        this.unitSystStts.setSystId(this.config.getProcessId());
    }

    @PreDestroy
    public void destroyService() {
        log.error("UnitSystService.destroy. system terminated.......");
        this.processStop();
    }

    public void processStop() {
        this.updateProcessState(false);
    }

    public void processStart() {
        this.updateProcessState(true);
    }

    public void processRunning() {
        this.processStart();
    }

    private void updateProcessState(boolean isRun) {
        boolean insHs = false;
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        if (min % 5 == 0 && this.historyMin != min) {
            this.historyMin = min;
            insHs = true;
        }
        this.unitSystStts.setSystSttsCd(isRun ? "SPS1" : "SPC3");
        this.unitSystStts.setUpdtDt(SysUtils.getSysTime());
        this.repo.updateUnitSystStts(this.unitSystStts);
        if (insHs) {
            this.repo.insertUnitSystSttsHs(this.unitSystStts);
        }
    }

    public UnitSystService(ApplicationConfig config, UnitSystRepository repo) {
        this.config = config;
        this.repo = repo;
    }
}

