/*
 * Decompiled with CFR 0.152.
 */
package com.its.vds.stat.server.service;

import com.its.vds.stat.server.annotation.ProcessingElapsed;
import com.its.vds.stat.server.dao.repository.VdsStatRepository;
import com.its.vds.stat.server.dto.VdsStatTimeDto;
import com.its.vds.stat.server.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class VdsStatServerService {
    private static final Logger log = LoggerFactory.getLogger(VdsStatServerService.class);
    private final VdsStatRepository repo;

    @ProcessingElapsed(type="05MIN", name="VDS 5\ubd84 \ud1b5\uacc4", starting=false)
    public int delVdsDtctHs(String statDt) {
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, statDt, statDt);
        return this.repo.delVdsDtctHs(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS 15\ubd84 \ud1b5\uacc4", starting=false)
    public int delVdsDtct15MinStat(String statDt) {
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, statDt, statDt);
        return this.repo.delVdsDtct15MinStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS 1\uc2dc\uac04 \ud1b5\uacc4", starting=false)
    public int delVdsDtctHhStat(String statDt) {
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, statDt, statDt);
        return this.repo.delVdsDtctHhStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS \uc77c \ud1b5\uacc4", starting=false)
    public int delVdsDtctDdStat(String statDt) {
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, statDt, statDt);
        return this.repo.delVdsDtctDdStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS 5\ubd84 \ud1b5\uacc4", starting=false)
    public int crtVdsDtctHs(String statDt, String fromDt, String toDt) {
        log.info("crtVdsDtctHs: currDt: {} statDt: {}, fromDt: {}, toDt: {}", new Object[]{TimeUtils.getCurrentTimeString(), statDt, fromDt, toDt});
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, fromDt, toDt);
        return this.repo.crtVdsDtctHs(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS 15\ubd84 \ud1b5\uacc4", starting=false)
    public int crtVdsDtct15MinStat(String statDt, String fromDt, String toDt) {
        log.info("crtVdsDtct15MinStat: currDt: {} statDt: {}, fromDt: {}, toDt: {}", new Object[]{TimeUtils.getCurrentTimeString(), statDt, fromDt, toDt});
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, fromDt, toDt);
        return this.repo.crtVdsDtct15MinStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS 1\uc2dc\uac04 \ud1b5\uacc4", starting=false)
    public int crtVdsDtctHhStat(String statDt, String fromDt, String toDt) {
        log.info("crtVdsDtctHhStat: currDt: {} statDt: {}, fromDt: {}, toDt: {}", new Object[]{TimeUtils.getCurrentTimeString(), statDt, fromDt, toDt});
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, fromDt, toDt);
        return this.repo.crtVdsDtctHhStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS \uc77c \ud1b5\uacc4", starting=false)
    public int crtVdsDtctDdStat(String statDt, String fromDt, String toDt) {
        log.info("crtVdsDtctDdStat: currDt: {} statDt: {}, fromDt: {}, toDt: {}", new Object[]{TimeUtils.getCurrentTimeString(), statDt, fromDt, toDt});
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, fromDt, toDt);
        return this.repo.crtVdsDtctDdStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS \uc6d4 \ud1b5\uacc4", starting=false)
    public int crtVdsDtctMnStat(String statDt, String fromDt, String toDt) {
        log.info("crtVdsDtctMnStat: currDt: {} statDt: {}, fromDt: {}, toDt: {}", new Object[]{TimeUtils.getCurrentTimeString(), statDt, fromDt, toDt});
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, fromDt, toDt);
        return this.repo.crtVdsDtctMnStat(statTime);
    }

    @ProcessingElapsed(type="05MIN", name="VDS \ub144 \ud1b5\uacc4", starting=false)
    public int crtVdsDtctYyStat(String statDt, String fromDt, String toDt) {
        log.info("crtVdsDtctYyStat: currDt: {} statDt: {}, fromDt: {}, toDt: {}", new Object[]{TimeUtils.getCurrentTimeString(), statDt, fromDt, toDt});
        VdsStatTimeDto statTime = new VdsStatTimeDto(statDt, fromDt, toDt);
        return this.repo.crtVdsDtctYyStat(statTime);
    }

    public VdsStatRepository getRepo() {
        return this.repo;
    }

    public VdsStatServerService(VdsStatRepository repo) {
        this.repo = repo;
    }
}

