/*
 * Decompiled with CFR 0.152.
 */
package core.log.exception;

import core.log.conf.reloadable.ReloadableConfiguration;
import core.log.logger.SL;

public class InternalException
extends Throwable {
    private String message;
    private Throwable t;

    public InternalException() {
    }

    public InternalException(String message, Throwable t) {
        super(message, t);
        this.message = message;
        this.t = t;
        if (ReloadableConfiguration.getInstance().getViewInternalException()) {
            SL.getInstance().logError(t, message);
        }
    }

    public InternalException(String message) {
        this.message = message;
        if (ReloadableConfiguration.getInstance().getViewInternalException()) {
            SL.getInstance().log((Object)message, 4);
        }
    }

    public InternalException(Throwable t) {
        super(t);
        this.t = t;
        this.message = t.getMessage();
        if (ReloadableConfiguration.getInstance().getViewInternalException()) {
            SL.getInstance().logError(t);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowableCause() {
        return this.t;
    }
}

