/*
 * Decompiled with CFR 0.152.
 */
package core.log.impl;

import core.log.aop.handler.DaoInfo;
import core.log.aop.reflection.ProfilingFactory;
import core.log.impl.PreparedStatementLoggableInterface;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class ConnectionLoggable
implements Connection {
    private Connection connection;

    public Statement createStatement() throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, resultSetType, resultSetConcurrency));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, sql));
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, sql, autoGeneratedKeys));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, sql, resultSetType, resultSetConcurrency));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, sql, columnIndexes));
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return (PreparedStatementLoggableInterface)ProfilingFactory.sqlTraceProfiling(new DaoInfo(this.connection, sql, columnNames));
    }

    public ConnectionLoggable(Connection connection) {
        this.connection = connection;
    }

    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }
}

