/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugProperty;
import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.OpcodeStackScanner;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.bytecode.MemberUtils;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.objectweb.asm.tree.ClassNode;

public class BugInstance
implements Comparable<BugInstance>,
XMLWriteable,
Cloneable {
    private final String type;
    private int priority;
    private final ArrayList<BugAnnotation> annotationList;
    private int cachedHashCode;
    private BugProperty propertyListHead;
    private BugProperty propertyListTail;
    private String oldInstanceHash;
    private String instanceHash;
    private int instanceOccurrenceNum;
    private int instanceOccurrenceMax;
    @CheckForNull
    private DetectorFactory detectorFactory;
    private long firstVersion;
    private long lastVersion;
    private boolean introducedByChangeOfExistingClass;
    private boolean removedByChangeOfPersistingClass;
    private static final int INVALID_HASH_CODE = 0;
    private static final String ELEMENT_NAME = "BugInstance";
    private static boolean adjustExperimental;
    private static Set<String> missingBugTypes;

    public BugInstance(String type, int priority) {
        this.type = type.intern();
        this.priority = priority;
        this.lastVersion = -1L;
        this.annotationList = new ArrayList(4);
        this.cachedHashCode = 0;
        BugPattern p = DetectorFactoryCollection.instance().lookupBugPattern(type);
        if (p == null) {
            if (missingBugTypes.add(type)) {
                String msg = "Can't find definition of bug type " + type;
                AnalysisContext.logError(msg, new NoSuchBugPattern(type));
            }
        } else {
            this.priority += p.getPriorityAdjustment();
        }
        if (adjustExperimental && this.isExperimental()) {
            this.priority = 4;
        }
        this.boundPriority();
    }

    public static DateFormat firstSeenXMLFormat() {
        return new SimpleDateFormat("M/d/yy h:mm a", Locale.ENGLISH);
    }

    private void boundPriority() {
        this.priority = this.boundedPriority(this.priority);
    }

    public Object clone() {
        try {
            BugInstance dup = (BugInstance)super.clone();
            for (int i = 0; i < dup.annotationList.size(); ++i) {
                dup.annotationList.set(i, (BugAnnotation)dup.annotationList.get(i).clone());
            }
            dup.propertyListTail = null;
            dup.propertyListHead = null;
            Iterator<BugProperty> i = this.propertyIterator();
            while (i.hasNext()) {
                dup.addProperty((BugProperty)i.next().clone());
            }
            return dup;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BugInstance(Detector detector, String type, int priority) {
        this(type, priority);
        if (detector != null) {
            String detectorName = detector.getClass().getName();
            this.adjustForDetector(detectorName);
        }
    }

    public void adjustForDetector(String detectorName) {
        DetectorFactory factory;
        this.detectorFactory = factory = DetectorFactoryCollection.instance().getFactoryByClassName(detectorName);
        if (factory != null) {
            this.priority += factory.getPriorityAdjustment();
            this.boundPriority();
            BugPattern bugPattern = this.getBugPattern();
            if (SystemProperties.ASSERTIONS_ENABLED && !"EXPERIMENTAL".equals(bugPattern.getCategory()) && !factory.getReportedBugPatterns().contains(bugPattern)) {
                AnalysisContext.logError(factory.getShortName() + " doesn't note that it reports " + bugPattern + " in category " + bugPattern.getCategory());
            }
        }
    }

    public BugInstance(Detector2 detector, String type, int priority) {
        this(type, priority);
        if (detector != null) {
            String detectorName = detector.getDetectorClassName();
            this.adjustForDetector(detectorName);
        }
    }

    public static void setAdjustExperimental(boolean adjust) {
        adjustExperimental = adjust;
    }

    public String getType() {
        return this.type;
    }

    @Nonnull
    public BugPattern getBugPattern() {
        BugPattern result = DetectorFactoryCollection.instance().lookupBugPattern(this.getType());
        if (result != null) {
            return result;
        }
        AnalysisContext.logError("Unable to find description of bug pattern " + this.getType());
        result = DetectorFactoryCollection.instance().lookupBugPattern("UNKNOWN");
        if (result != null) {
            return result;
        }
        return BugPattern.REALLY_UNKNOWN;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getBugRank() {
        return BugRanker.findRank(this);
    }

    public BugRankCategory getBugRankCategory() {
        return BugRankCategory.getRank(this.getBugRank());
    }

    public String getPriorityTypeString() {
        String priorityString = this.getPriorityString();
        BugPattern bugPattern = this.getBugPattern();
        String categoryString = I18N.instance().getBugCategoryDescription(bugPattern.getCategory());
        return priorityString + " Confidence " + categoryString;
    }

    public String getPriorityTypeAbbreviation() {
        String priorityString = this.getPriorityAbbreviation();
        return priorityString + " " + this.getCategoryAbbrev();
    }

    public String getCategoryAbbrev() {
        BugPattern bugPattern = this.getBugPattern();
        return bugPattern.getCategoryAbbrev();
    }

    public String getPriorityString() {
        int value = this.getPriority();
        String priorityString = value == 1 ? L10N.getLocalString("sort.priority_high", "High") : (value == 2 ? L10N.getLocalString("sort.priority_normal", "Medium") : (value == 3 ? L10N.getLocalString("sort.priority_low", "Low") : (value == 4 ? L10N.getLocalString("sort.priority_experimental", "Experimental") : L10N.getLocalString("sort.priority_ignore", "Ignore"))));
        return priorityString;
    }

    public String getPriorityAbbreviation() {
        return this.getPriorityString().substring(0, 1);
    }

    public void setPriority(int p) {
        this.priority = this.boundedPriority(p);
    }

    private int boundedPriority(int p) {
        return Math.max(1, Math.min(5, p));
    }

    public void raisePriority() {
        this.priority = this.boundedPriority(this.priority - 1);
    }

    public void lowerPriority() {
        this.priority = this.boundedPriority(this.priority + 1);
    }

    public void lowerPriorityALot() {
        this.priority = this.boundedPriority(this.priority + 2);
    }

    public boolean isExperimental() {
        BugPattern pattern = this.getBugPattern();
        return pattern.isExperimental();
    }

    public ClassAnnotation getPrimaryClass() {
        return this.findPrimaryAnnotationOfType(ClassAnnotation.class);
    }

    @CheckForNull
    public TypeAnnotation getPrimaryType() {
        return this.findPrimaryAnnotationOfType(TypeAnnotation.class);
    }

    @CheckForNull
    public MethodAnnotation getPrimaryMethod() {
        return this.findPrimaryAnnotationOfType(MethodAnnotation.class);
    }

    @CheckForNull
    public FieldAnnotation getPrimaryField() {
        return this.findPrimaryAnnotationOfType(FieldAnnotation.class);
    }

    @Nonnull
    public BugInstance lowerPriorityIfDeprecated() {
        FieldAnnotation f;
        MethodAnnotation m = this.getPrimaryMethod();
        if (m != null && XFactory.createXMethod(m).isDeprecated()) {
            this.lowerPriority();
        }
        if ((f = this.getPrimaryField()) != null && XFactory.createXField(f).isDeprecated()) {
            this.lowerPriority();
        }
        return this;
    }

    @CheckForNull
    private <T extends BugAnnotation> T findPrimaryAnnotationOfType(Class<T> cls) {
        BugAnnotation firstMatch = null;
        Iterator<BugAnnotation> i = this.annotationIterator();
        while (i.hasNext()) {
            BugAnnotation annotation = i.next();
            if (!cls.isAssignableFrom(annotation.getClass())) continue;
            if (annotation.getDescription().endsWith("DEFAULT")) {
                return (T)((BugAnnotation)cls.cast(annotation));
            }
            if (firstMatch != null) continue;
            firstMatch = (BugAnnotation)cls.cast(annotation);
        }
        return (T)firstMatch;
    }

    public LocalVariableAnnotation getPrimaryLocalVariableAnnotation() {
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof LocalVariableAnnotation)) continue;
            return (LocalVariableAnnotation)annotation;
        }
        return null;
    }

    @Nonnull
    public SourceLineAnnotation getPrimarySourceLineAnnotation() {
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof SourceLineAnnotation) || !"SOURCE_LINE_DEFAULT".equals(annotation.getDescription()) || ((SourceLineAnnotation)annotation).isUnknown()) continue;
            return (SourceLineAnnotation)annotation;
        }
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof SourceLineAnnotation) || ((SourceLineAnnotation)annotation).isUnknown()) continue;
            return (SourceLineAnnotation)annotation;
        }
        SourceLineAnnotation srcLine = this.inspectPackageMemberSourceLines(this.getPrimaryMethod());
        if (srcLine != null) {
            return srcLine;
        }
        srcLine = this.inspectPackageMemberSourceLines(this.getPrimaryField());
        if (srcLine != null) {
            return srcLine;
        }
        srcLine = this.inspectPackageMemberSourceLines(this.getPrimaryClass());
        if (srcLine != null) {
            return srcLine;
        }
        throw new IllegalStateException("BugInstance for " + this.getType() + " must contain at least one class, method, or field annotation");
    }

    public Collection<? extends SourceLineAnnotation> getAnotherInstanceSourceLineAnnotations() {
        ArrayList<SourceLineAnnotation> result = new ArrayList<SourceLineAnnotation>();
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof SourceLineAnnotation) || !"SOURCE_LINE_ANOTHER_INSTANCE".equals(annotation.getDescription()) || ((SourceLineAnnotation)annotation).isUnknown()) continue;
            result.add((SourceLineAnnotation)annotation);
        }
        return result;
    }

    public String getInstanceKey() {
        String newValue = this.getInstanceKeyNew();
        return newValue;
    }

    private String getInstanceKeyNew() {
        StringBuilder buf = new StringBuilder(this.type);
        for (BugAnnotation annotation : this.annotationList) {
            if (!annotation.isSignificant() && !(annotation instanceof IntAnnotation) && !(annotation instanceof LocalVariableAnnotation)) continue;
            buf.append(":");
            buf.append(annotation.format("hash", null));
        }
        return buf.toString();
    }

    private SourceLineAnnotation inspectPackageMemberSourceLines(PackageMemberAnnotation packageMember) {
        return packageMember != null ? packageMember.getSourceLines() : null;
    }

    public Iterator<BugAnnotation> annotationIterator() {
        return this.annotationList.iterator();
    }

    public List<? extends BugAnnotation> getAnnotations() {
        return this.annotationList;
    }

    @CheckForNull
    public <A extends BugAnnotation> A getAnnotationWithRole(Class<A> c, String role) {
        for (BugAnnotation a : this.annotationList) {
            if (!c.isInstance(a) || !Objects.equals(role, a.getDescription())) continue;
            return (A)((BugAnnotation)c.cast(a));
        }
        return null;
    }

    public String getAbbrev() {
        BugPattern pattern = this.getBugPattern();
        return pattern.getAbbrev();
    }

    public String getProperty(String name) {
        BugProperty prop = this.lookupProperty(name);
        return prop != null ? prop.getValue() : null;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public Iterator<BugProperty> propertyIterator() {
        return new BugPropertyIterator();
    }

    @Nonnull
    public BugInstance setProperty(String name, String value) {
        BugProperty prop = this.lookupProperty(name);
        if (prop != null) {
            prop.setValue(value);
        } else {
            prop = new BugProperty(name, value);
            this.addProperty(prop);
        }
        return this;
    }

    public BugProperty lookupProperty(String name) {
        BugProperty prop;
        for (prop = this.propertyListHead; prop != null && !prop.getName().equals(name); prop = prop.getNext()) {
        }
        return prop;
    }

    public boolean deleteProperty(String name) {
        BugProperty prop;
        BugProperty prev = null;
        for (prop = this.propertyListHead; prop != null && !prop.getName().equals(name); prop = prop.getNext()) {
            prev = prop;
        }
        if (prop != null) {
            if (prev != null) {
                prev.setNext(prop.getNext());
            } else {
                this.propertyListHead = prop.getNext();
            }
            if (prop.getNext() == null) {
                this.propertyListTail = prev;
            }
            return true;
        }
        return false;
    }

    private void addProperty(BugProperty prop) {
        if (this.propertyListTail != null) {
            this.propertyListTail.setNext(prop);
            this.propertyListTail = prop;
        } else {
            this.propertyListHead = this.propertyListTail = prop;
        }
        prop.setNext(null);
    }

    @Nonnull
    public BugInstance addAnnotations(Collection<? extends BugAnnotation> annotationCollection) {
        for (BugAnnotation bugAnnotation : annotationCollection) {
            this.add(bugAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addClassAndMethod(MethodDescriptor methodDescriptor) {
        this.addClass(ClassName.toDottedClassName(methodDescriptor.getSlashedClassName()));
        this.add(MethodAnnotation.fromMethodDescriptor(methodDescriptor));
        return this;
    }

    public BugInstance addClassAndMethod(XMethod xMethod) {
        return this.addClassAndMethod(xMethod.getMethodDescriptor());
    }

    @Nonnull
    public BugInstance addClassAndMethod(PreorderVisitor visitor) {
        this.addClass(visitor);
        XMethod m = visitor.getXMethod();
        this.addMethod(visitor);
        if (!MemberUtils.isUserGenerated(m)) {
            this.foundInAutogeneratedMethod();
        }
        return this;
    }

    private void foundInAutogeneratedMethod() {
        if (this.annotationList.size() != 2) {
            return;
        }
        this.priority += 2;
        this.setProperty("FOUND_IN_SYNTHETIC_METHOD", "true");
        if (SystemProperties.ASSERTIONS_ENABLED && AnalysisContext.analyzingApplicationClass() && this.priority <= 3) {
            AnalysisContext.logError("Adding error " + this.getBugPattern().getType() + " to synthetic method " + this.getPrimaryMethod());
        }
    }

    @Nonnull
    public BugInstance addClassAndMethod(MethodAnnotation methodAnnotation) {
        this.addClass(methodAnnotation.getClassName());
        this.addMethod(methodAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addClassAndMethod(MethodGen methodGen, String sourceFile) {
        this.addClass(methodGen.getClassName());
        this.addMethod(methodGen, sourceFile);
        if (!MemberUtils.isUserGenerated((FieldGenOrMethodGen)methodGen)) {
            this.foundInAutogeneratedMethod();
        }
        return this;
    }

    @Nonnull
    public BugInstance addClassAndMethod(JavaClass javaClass, Method method) {
        this.addClass(javaClass.getClassName());
        this.addMethod(javaClass, method);
        if (!MemberUtils.isUserGenerated((FieldOrMethod)method)) {
            this.foundInAutogeneratedMethod();
        }
        return this;
    }

    @Nonnull
    public BugInstance addClass(String className, String sourceFileName) {
        ClassAnnotation classAnnotation = new ClassAnnotation(className, sourceFileName);
        this.add(classAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addClass(@SlashedClassName(when=When.UNKNOWN) String className) {
        ClassAnnotation classAnnotation = new ClassAnnotation(ClassName.toDottedClassName(className));
        this.add(classAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addClass(ClassNode classNode) {
        String dottedClassName = ClassName.toDottedClassName(classNode.name);
        ClassAnnotation classAnnotation = new ClassAnnotation(dottedClassName);
        this.add(classAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addClass(ClassDescriptor classDescriptor) {
        this.add(ClassAnnotation.fromClassDescriptor(classDescriptor));
        return this;
    }

    @Nonnull
    public BugInstance addClass(JavaClass jclass) {
        this.addClass(jclass.getClassName());
        return this;
    }

    @Nonnull
    public BugInstance addClass(PreorderVisitor visitor) {
        String className = visitor.getDottedClassName();
        this.addClass(className);
        return this;
    }

    @Nonnull
    public BugInstance addSuperclass(PreorderVisitor visitor) {
        String className = ClassName.toDottedClassName(visitor.getSuperclassName());
        this.addClass(className);
        return this;
    }

    @Nonnull
    public BugInstance addType(String typeDescriptor) {
        TypeAnnotation typeAnnotation = new TypeAnnotation(typeDescriptor);
        this.add(typeAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addType(Type type) {
        TypeAnnotation typeAnnotation = new TypeAnnotation(type);
        this.add(typeAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addFoundAndExpectedType(Type foundType, Type expectedType) {
        this.add(new TypeAnnotation(foundType, "TYPE_FOUND"));
        this.add(new TypeAnnotation(expectedType, "TYPE_EXPECTED"));
        return this;
    }

    @Nonnull
    public BugInstance addFoundAndExpectedType(String foundType, String expectedType) {
        this.add(new TypeAnnotation(foundType, "TYPE_FOUND"));
        this.add(new TypeAnnotation(expectedType, "TYPE_EXPECTED"));
        return this;
    }

    @Nonnull
    public BugInstance addEqualsMethodUsed(ClassDescriptor expectedClass) {
        try {
            Set<XMethod> targets = Hierarchy2.resolveVirtualMethodCallTargets(expectedClass, "equals", "(Ljava/lang/Object;)Z", false, false);
            this.addEqualsMethodUsed(targets);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return this;
    }

    @Nonnull
    public BugInstance addEqualsMethodUsed(@CheckForNull Collection<XMethod> equalsMethods) {
        if (equalsMethods == null) {
            return this;
        }
        if (equalsMethods.size() < 5) {
            for (XMethod m : equalsMethods) {
                this.addMethod(m).describe("METHOD_EQUALS_USED");
            }
        } else {
            this.addMethod(equalsMethods.iterator().next()).describe("METHOD_EQUALS_USED");
        }
        return this;
    }

    @Nonnull
    public BugInstance addTypeOfNamedClass(@DottedClassName String typeName) {
        TypeAnnotation typeAnnotation = new TypeAnnotation("L" + typeName.replace('.', '/') + ";");
        this.add(typeAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addType(ClassDescriptor c) {
        TypeAnnotation typeAnnotation = new TypeAnnotation(c.getSignature());
        this.add(typeAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addField(String className, String fieldName, String fieldSig, boolean isStatic) {
        this.addField(new FieldAnnotation(className, fieldName, fieldSig, isStatic));
        return this;
    }

    @Nonnull
    public BugInstance addField(String className, String fieldName, String fieldSig, int accessFlags) {
        this.addField(new FieldAnnotation(className, fieldName, fieldSig, accessFlags));
        return this;
    }

    @Nonnull
    public BugInstance addField(PreorderVisitor visitor) {
        FieldAnnotation fieldAnnotation = FieldAnnotation.fromVisitedField(visitor);
        return this.addField(fieldAnnotation);
    }

    @Nonnull
    public BugInstance addField(FieldAnnotation fieldAnnotation) {
        this.add(fieldAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addField(FieldVariable field) {
        return this.addField(field.getClassName(), field.getFieldName(), field.getFieldSig(), field.isStatic());
    }

    @Nonnull
    public BugInstance addOptionalField(@CheckForNull XField xfield) {
        if (xfield == null) {
            return this;
        }
        return this.addField(xfield.getClassName(), xfield.getName(), xfield.getSignature(), xfield.isStatic());
    }

    @Nonnull
    public BugInstance addField(XField xfield) {
        return this.addField(xfield.getClassName(), xfield.getName(), xfield.getSignature(), xfield.isStatic());
    }

    @Nonnull
    public BugInstance addField(FieldDescriptor fieldDescriptor) {
        FieldAnnotation fieldAnnotation = FieldAnnotation.fromFieldDescriptor(fieldDescriptor);
        this.add(fieldAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addReferencedField(DismantleBytecode visitor) {
        FieldAnnotation f = FieldAnnotation.fromReferencedField(visitor);
        this.addField(f);
        return this;
    }

    @Nonnull
    public BugInstance addReferencedField(FieldAnnotation fa) {
        this.addField(fa);
        return this;
    }

    @Nonnull
    public BugInstance addVisitedField(PreorderVisitor visitor) {
        FieldAnnotation f = FieldAnnotation.fromVisitedField(visitor);
        this.addField(f);
        return this;
    }

    @Nonnull
    public BugInstance addOptionalLocalVariable(DismantleBytecode dbc, OpcodeStack.Item item) {
        int register = item.getRegisterNumber();
        if (register >= 0) {
            this.add(LocalVariableAnnotation.getLocalVariableAnnotation(dbc.getMethod(), register, dbc.getPC() - 1, dbc.getPC()));
        }
        return this;
    }

    @Nonnull
    public BugInstance addMethod(String className, String methodName, String methodSig, boolean isStatic) {
        this.addMethod(MethodAnnotation.fromForeignMethod(className, methodName, methodSig, isStatic));
        return this;
    }

    @Nonnull
    public BugInstance addMethod(@SlashedClassName String className, String methodName, String methodSig, int accessFlags) {
        this.addMethod(MethodAnnotation.fromForeignMethod(className, methodName, methodSig, accessFlags));
        return this;
    }

    @Nonnull
    public BugInstance addMethod(MethodGen methodGen, String sourceFile) {
        String className = methodGen.getClassName();
        MethodAnnotation methodAnnotation = new MethodAnnotation(className, methodGen.getName(), methodGen.getSignature(), methodGen.isStatic());
        this.addMethod(methodAnnotation);
        this.addSourceLinesForMethod(methodAnnotation, SourceLineAnnotation.fromVisitedMethod(methodGen, sourceFile));
        return this;
    }

    @Nonnull
    public BugInstance addMethod(JavaClass javaClass, Method method) {
        MethodAnnotation methodAnnotation = new MethodAnnotation(javaClass.getClassName(), method.getName(), method.getSignature(), method.isStatic());
        SourceLineAnnotation methodSourceLines = SourceLineAnnotation.forEntireMethod(javaClass, method);
        methodAnnotation.setSourceLines(methodSourceLines);
        this.addMethod(methodAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addMethod(JavaClassAndMethod classAndMethod) {
        return this.addMethod(classAndMethod.getJavaClass(), classAndMethod.getMethod());
    }

    @Nonnull
    public BugInstance addMethod(PreorderVisitor visitor) {
        MethodAnnotation methodAnnotation = MethodAnnotation.fromVisitedMethod(visitor);
        this.addMethod(methodAnnotation);
        this.addSourceLinesForMethod(methodAnnotation, SourceLineAnnotation.fromVisitedMethod(visitor));
        return this;
    }

    @Nonnull
    public BugInstance addCalledMethod(DismantleBytecode visitor) {
        return this.addMethod(MethodAnnotation.fromCalledMethod(visitor)).describe("METHOD_CALLED");
    }

    @Nonnull
    public BugInstance addCalledMethod(XMethod m) {
        return this.addMethod(m).describe("METHOD_CALLED");
    }

    @Nonnull
    public BugInstance addCalledMethod(String className, String methodName, String methodSig, boolean isStatic) {
        return this.addMethod(MethodAnnotation.fromCalledMethod(className, methodName, methodSig, isStatic)).describe("METHOD_CALLED");
    }

    @Nonnull
    public BugInstance addCalledMethod(ConstantPoolGen cpg, InvokeInstruction inv) {
        String className = inv.getClassName(cpg);
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        this.addMethod(className, methodName, methodSig, inv.getOpcode() == 184);
        this.describe("METHOD_CALLED");
        return this;
    }

    @Nonnull
    public BugInstance addCalledMethod(MethodGen methodGen, InvokeInstruction inv) {
        ConstantPoolGen cpg = methodGen.getConstantPool();
        return this.addCalledMethod(cpg, inv);
    }

    @Nonnull
    public BugInstance addMethod(XMethod xmethod) {
        this.addMethod(MethodAnnotation.fromXMethod(xmethod));
        return this;
    }

    @Nonnull
    public BugInstance addMethod(MethodDescriptor method) {
        this.addMethod(MethodAnnotation.fromMethodDescriptor(method));
        return this;
    }

    @Nonnull
    public BugInstance addMethod(MethodAnnotation methodAnnotation) {
        this.add(methodAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addInt(int value) {
        this.add(new IntAnnotation(value));
        return this;
    }

    @Nonnull
    public BugInstance addParameterAnnotation(int index, String role) {
        return this.addInt(index + 1).describe(role);
    }

    @Nonnull
    public BugInstance addString(String value) {
        this.add(StringAnnotation.fromRawString(value));
        return this;
    }

    @Nonnull
    public BugInstance addString(char c) {
        this.add(StringAnnotation.fromRawString(Character.toString(c)));
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(SourceLineAnnotation sourceLine) {
        this.add(sourceLine);
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(BytecodeScanningDetector visitor, int pc) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(visitor.getClassContext(), visitor, pc);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(ClassContext classContext, PreorderVisitor visitor, int pc) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, visitor, pc);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(ClassContext classContext, MethodGen methodGen, String sourceFile, @Nonnull InstructionHandle handle) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(ClassContext classContext, MethodGen methodGen, String sourceFile, InstructionHandle start, InstructionHandle end) {
        SourceLineAnnotation sourceLineAnnotation;
        if (start.getPosition() > end.getPosition()) {
            InstructionHandle tmp = start;
            start = end;
            end = tmp;
        }
        if ((sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(classContext, methodGen, sourceFile, start, end)) != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(ClassContext classContext, Method method, Location location) {
        return this.addSourceLine(classContext, method, location.getHandle());
    }

    @Nonnull
    public BugInstance addSourceLine(MethodDescriptor methodDescriptor, Location location) {
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            ClassContext classContext = analysisCache.getClassAnalysis(ClassContext.class, methodDescriptor.getClassDescriptor());
            Method method = analysisCache.getMethodAnalysis(Method.class, methodDescriptor);
            return this.addSourceLine(classContext, method, location);
        }
        catch (CheckedAnalysisException e) {
            return this.addSourceLine(SourceLineAnnotation.createReallyUnknown(methodDescriptor.getClassDescriptor().toDottedClassName()));
        }
    }

    @Nonnull
    public BugInstance addSourceLine(ClassContext classContext, Method method, InstructionHandle handle) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, method, handle.getPosition());
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addSourceLineRange(BytecodeScanningDetector visitor, int startPC, int endPC) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(visitor.getClassContext(), visitor, startPC, endPC);
        Objects.requireNonNull(sourceLineAnnotation);
        this.add(sourceLineAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addSourceLineRange(ClassContext classContext, PreorderVisitor visitor, int startPC, int endPC) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(classContext, visitor, startPC, endPC);
        Objects.requireNonNull(sourceLineAnnotation);
        this.add(sourceLineAnnotation);
        return this;
    }

    @Nonnull
    public BugInstance addSourceLine(BytecodeScanningDetector visitor) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(visitor);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public BugInstance addUnknownSourceLine(String className, String sourceFile) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.createUnknown(className, sourceFile);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    @Nonnull
    public String getMessageWithoutPrefix() {
        BugPattern bugPattern = this.getBugPattern();
        String pattern = this.getLongDescription();
        String shortPattern = bugPattern.getShortDescription();
        try {
            FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
            return format.format(this.annotationList.toArray(new BugAnnotation[this.annotationList.size()]), this.getPrimaryClass());
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error generating bug msg ", e);
            return shortPattern + " [Error generating customized description]";
        }
    }

    String getLongDescription() {
        return this.getBugPattern().getLongDescription().replaceAll("BUG_PATTERN", this.type);
    }

    public String getAbridgedMessage() {
        BugPattern bugPattern = this.getBugPattern();
        String pattern = this.getLongDescription().replaceAll(" in \\{1\\}", "");
        String shortPattern = bugPattern.getShortDescription();
        try {
            FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
            return format.format(this.annotationList.toArray(new BugAnnotation[this.annotationList.size()]), this.getPrimaryClass(), true);
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error generating bug msg ", e);
            return shortPattern + " [Error3 generating customized description]";
        }
    }

    public String getMessage() {
        BugPattern bugPattern = this.getBugPattern();
        String pattern = bugPattern.getAbbrev() + ": " + this.getLongDescription();
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        try {
            return format.format(this.annotationList.toArray(new BugAnnotation[this.annotationList.size()]), this.getPrimaryClass());
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error generating bug msg ", e);
            return bugPattern.getShortDescription() + " [Error generating customized description]";
        }
    }

    public String getMessageWithPriorityType() {
        return "(" + this.getPriorityTypeString() + ") " + this.getMessage();
    }

    public String getMessageWithPriorityTypeAbbreviation() {
        return this.getPriorityTypeAbbreviation() + " " + this.getMessage();
    }

    @Nonnull
    public BugInstance describe(String description) {
        this.annotationList.get(this.annotationList.size() - 1).setDescription(description);
        return this;
    }

    public String toString() {
        return I18N.instance().getShortMessage(this.type);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, null, false);
    }

    public int getCWEid() {
        BugPattern pattern = this.getBugPattern();
        int cweid = pattern.getCWEid();
        if (cweid != 0) {
            return cweid;
        }
        BugCode bugCode = pattern.getBugCode();
        return bugCode.getCWEid();
    }

    public void writeXML(XMLOutput xmlOutput, BugCollection bugCollection, boolean addMessages) throws IOException {
        Map primaryAnnotations;
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("type", this.type).addAttribute("priority", String.valueOf(this.priority));
        attributeList.addAttribute("rank", Integer.toString(this.getBugRank()));
        BugPattern pattern = this.getBugPattern();
        attributeList.addAttribute("abbrev", pattern.getAbbrev());
        attributeList.addAttribute("category", pattern.getCategory());
        if (addMessages) {
            attributeList.addAttribute("instanceHash", this.getInstanceHash());
            attributeList.addAttribute("instanceOccurrenceNum", Integer.toString(this.getInstanceOccurrenceNum()));
            attributeList.addAttribute("instanceOccurrenceMax", Integer.toString(this.getInstanceOccurrenceMax()));
            int cweid = this.getCWEid();
            if (cweid != 0) {
                attributeList.addAttribute("cweid", Integer.toString(cweid));
            }
        } else if (this.oldInstanceHash != null && !this.isInstanceHashConsistent()) {
            attributeList.addAttribute("oldInstanceHash", this.oldInstanceHash);
        }
        if (this.firstVersion > 0L) {
            attributeList.addAttribute("first", Long.toString(this.firstVersion));
        }
        if (this.lastVersion >= 0L) {
            attributeList.addAttribute("last", Long.toString(this.lastVersion));
        }
        if (this.introducedByChangeOfExistingClass) {
            attributeList.addAttribute("introducedByChange", "true");
        }
        if (this.removedByChangeOfPersistingClass) {
            attributeList.addAttribute("removedByChange", "true");
        }
        xmlOutput.openTag(ELEMENT_NAME, attributeList);
        if (addMessages) {
            BugPattern bugPattern = this.getBugPattern();
            xmlOutput.openTag("ShortMessage");
            xmlOutput.writeText(bugPattern.getShortDescription());
            xmlOutput.closeTag("ShortMessage");
            xmlOutput.openTag("LongMessage");
            if (FindBugsDisplayFeatures.isAbridgedMessages()) {
                xmlOutput.writeText(this.getAbridgedMessage());
            } else {
                xmlOutput.writeText(this.getMessageWithoutPrefix());
            }
            xmlOutput.closeTag("LongMessage");
        }
        if (addMessages) {
            primaryAnnotations = new IdentityHashMap();
            primaryAnnotations.put(this.getPrimarySourceLineAnnotation(), null);
            primaryAnnotations.put(this.getPrimaryClass(), null);
            primaryAnnotations.put(this.getPrimaryField(), null);
            primaryAnnotations.put(this.getPrimaryMethod(), null);
        } else {
            primaryAnnotations = Collections.emptyMap();
        }
        boolean foundSourceAnnotation = false;
        for (BugAnnotation annotation : this.annotationList) {
            if (annotation instanceof SourceLineAnnotation) {
                foundSourceAnnotation = true;
            }
            annotation.writeXML(xmlOutput, addMessages, primaryAnnotations.containsKey(annotation));
        }
        if (!foundSourceAnnotation && addMessages) {
            SourceLineAnnotation synth = this.getPrimarySourceLineAnnotation();
            synth.setSynthetic(true);
            synth.writeXML(xmlOutput, addMessages, false);
        }
        if (this.propertyListHead != null) {
            ArrayList<BugProperty> props = new ArrayList<BugProperty>();
            for (BugProperty prop = this.propertyListHead; prop != null; prop = prop.getNext()) {
                props.add(prop);
            }
            Collections.sort(props, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            for (BugProperty prop : props) {
                prop.writeXML(xmlOutput);
            }
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    private int ageInDays(BugCollection bugCollection, long firstSeen) {
        long age = bugCollection.getAnalysisTimestamp() - firstSeen;
        if (age < 0L) {
            age = 0L;
        }
        int ageInDays = (int)(age / 1000L / 3600L / 24L);
        return ageInDays;
    }

    public BugInstance addOptionalAnnotation(@CheckForNull BugAnnotation annotation) {
        if (annotation == null) {
            return this;
        }
        return this.add(annotation);
    }

    public BugInstance addOptionalAnnotation(@CheckForNull BugAnnotation annotation, String role) {
        if (annotation == null) {
            return this;
        }
        return this.add(annotation).describe(role);
    }

    public BugInstance add(@Nonnull BugAnnotation annotation) {
        Objects.requireNonNull(annotation, "Missing BugAnnotation!");
        this.annotationList.add(annotation);
        this.cachedHashCode = 0;
        return this;
    }

    public BugInstance addSomeSourceForTopTwoStackValues(ClassContext classContext, Method method, Location location) {
        block2: {
            int pc = location.getHandle().getPosition();
            try {
                OpcodeStack stack = OpcodeStackScanner.getStackAt(classContext.getJavaClass(), method, pc);
                BugAnnotation a1 = BugInstance.getSomeSource(classContext, method, location, stack, 1);
                BugAnnotation a0 = BugInstance.getSomeSource(classContext, method, location, stack, 0);
                this.addOptionalUniqueAnnotations(a0, a1);
            }
            catch (OpcodeStackScanner.UnreachableCodeException e) {
                if (!SystemProperties.ASSERTIONS_ENABLED) break block2;
                AnalysisContext.logError(e.getMessage(), e);
            }
        }
        return this;
    }

    public BugInstance addSourceForTopStackValue(ClassContext classContext, Method method, Location location) {
        BugAnnotation b = BugInstance.getSourceForTopStackValue(classContext, method, location);
        return this.addOptionalAnnotation(b);
    }

    @CheckForNull
    public static BugAnnotation getSourceForTopStackValue(ClassContext classContext, Method method, Location location) {
        return BugInstance.getSourceForStackValue(classContext, method, location, 0);
    }

    @CheckForNull
    public static BugAnnotation getSourceForStackValue(ClassContext classContext, Method method, Location location, int depth) {
        try {
            int pc = location.getHandle().getPosition();
            OpcodeStack stack = OpcodeStackScanner.getStackAt(classContext.getJavaClass(), method, pc);
            BugAnnotation a0 = BugInstance.getSomeSource(classContext, method, location, stack, depth);
            return a0;
        }
        catch (OpcodeStackScanner.UnreachableCodeException e) {
            if (SystemProperties.ASSERTIONS_ENABLED) {
                AnalysisContext.logError(e.getMessage(), e);
            }
            return null;
        }
    }

    @CheckForNull
    public static BugAnnotation getSomeSource(ClassContext classContext, Method method, Location location, OpcodeStack stack, int stackPos) {
        if (stack.isTop()) {
            return null;
        }
        int pc = location.getHandle().getPosition();
        try {
            BugAnnotation result = ValueNumberSourceInfo.getFromValueNumber(classContext, method, location, stackPos);
            if (result != null) {
                return result;
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Couldn't find value source", e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("Couldn't find value source", e);
        }
        return BugInstance.getValueSource(stack.getStackItem(stackPos), method, pc);
    }

    @CheckForNull
    public static BugAnnotation getValueSource(OpcodeStack.Item item, Method method, int pc) {
        LocalVariableAnnotation lv = LocalVariableAnnotation.getLocalVariableAnnotation(method, item, pc);
        if (lv != null && lv.isNamed()) {
            return lv;
        }
        BugAnnotation a = BugInstance.getFieldOrMethodValueSource(item);
        if (a != null) {
            return a;
        }
        Object c = item.getConstant();
        if (c instanceof String) {
            a = new StringAnnotation((String)c);
            a.setDescription("STRING_CONSTANT");
            return a;
        }
        if (c instanceof Integer && !item.isArray()) {
            a = new IntAnnotation((Integer)c);
            a.setDescription("INT_VALUE");
            return a;
        }
        return null;
    }

    public BugInstance addValueSource(@CheckForNull OpcodeStack.Item item, DismantleBytecode dbc) {
        if (item != null) {
            this.addValueSource(item, dbc.getMethod(), dbc.getPC());
        }
        return this;
    }

    public BugInstance addValueSource(OpcodeStack.Item item, Method method, int pc) {
        this.addOptionalAnnotation(BugInstance.getValueSource(item, method, pc));
        return this;
    }

    public BugInstance addFieldOrMethodValueSource(OpcodeStack.Item item) {
        this.addOptionalAnnotation(BugInstance.getFieldOrMethodValueSource(item));
        return this;
    }

    public BugInstance addOptionalUniqueAnnotations(BugAnnotation ... annotations) {
        HashSet<BugAnnotation> added = new HashSet<BugAnnotation>();
        for (BugAnnotation a : annotations) {
            if (a == null || !added.add(a)) continue;
            this.add(a);
        }
        return this;
    }

    public boolean tryAddingOptionalUniqueAnnotations(BugAnnotation ... annotations) {
        HashSet<BugAnnotation> added = new HashSet<BugAnnotation>();
        for (BugAnnotation a : annotations) {
            if (a == null || !added.add(a)) continue;
            this.add(a);
        }
        return !added.isEmpty();
    }

    public BugInstance addOptionalUniqueAnnotationsWithFallback(BugAnnotation fallback, BugAnnotation ... annotations) {
        HashSet<BugAnnotation> added = new HashSet<BugAnnotation>();
        for (BugAnnotation a : annotations) {
            if (a == null || !added.add(a)) continue;
            this.add(a);
        }
        if (added.isEmpty()) {
            this.add(fallback);
        }
        return this;
    }

    @CheckForNull
    public static BugAnnotation getFieldOrMethodValueSource(@CheckForNull OpcodeStack.Item item) {
        if (item == null) {
            return null;
        }
        XField xField = item.getXField();
        if (xField != null) {
            FieldAnnotation a = FieldAnnotation.fromXField(xField);
            a.setDescription("FIELD_VALUE_OF");
            return a;
        }
        XMethod xMethod = item.getReturnValueOf();
        if (xMethod != null) {
            MethodAnnotation a = MethodAnnotation.fromXMethod(xMethod);
            a.setDescription("METHOD_RETURN_VALUE_OF");
            return a;
        }
        return null;
    }

    private void addSourceLinesForMethod(MethodAnnotation methodAnnotation, SourceLineAnnotation sourceLineAnnotation) {
        if (sourceLineAnnotation != null) {
            methodAnnotation.setSourceLines(sourceLineAnnotation);
        }
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int hashcode = this.type.hashCode() + this.priority;
            Iterator<BugAnnotation> i = this.annotationIterator();
            while (i.hasNext()) {
                hashcode += i.next().hashCode();
            }
            if (hashcode == 0) {
                hashcode = 1;
            }
            this.cachedHashCode = hashcode;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BugInstance)) {
            return false;
        }
        BugInstance other = (BugInstance)o;
        if (!this.type.equals(other.type) || this.priority != other.priority) {
            return false;
        }
        if (this.annotationList.size() != other.annotationList.size()) {
            return false;
        }
        int numAnnotations = this.annotationList.size();
        for (int i = 0; i < numAnnotations; ++i) {
            BugAnnotation rhs;
            BugAnnotation lhs = this.annotationList.get(i);
            if (lhs.equals(rhs = other.annotationList.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BugInstance other) {
        int cmp = this.type.compareTo(other.type);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.priority - other.priority;
        if (cmp != 0) {
            return cmp;
        }
        int pfxLen = Math.min(this.annotationList.size(), other.annotationList.size());
        for (int i = 0; i < pfxLen; ++i) {
            BugAnnotation rhs;
            BugAnnotation lhs = this.annotationList.get(i);
            cmp = lhs.compareTo(rhs = other.annotationList.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.annotationList.size() - other.annotationList.size();
    }

    public void setFirstVersion(long firstVersion) {
        if (this.lastVersion >= 0L && firstVersion > this.lastVersion) {
            throw new IllegalArgumentException(firstVersion + ".." + this.lastVersion);
        }
        this.firstVersion = firstVersion;
    }

    public void clearHistory() {
        this.setFirstVersion(0L);
        this.setLastVersion(-1L);
        this.setIntroducedByChangeOfExistingClass(false);
        this.setRemovedByChangeOfPersistingClass(false);
    }

    public long getFirstVersion() {
        return this.firstVersion;
    }

    public void setHistory(BugInstance from) {
        long first = from.getFirstVersion();
        long last = from.getLastVersion();
        if (first > 0L && last >= 0L && first > last) {
            throw new IllegalArgumentException("from has version range " + first + "..." + last + " in " + from.getBugPattern() + "\n" + from.getMessage());
        }
        this.setFirstVersion(first);
        this.setLastVersion(last);
        this.removedByChangeOfPersistingClass = from.removedByChangeOfPersistingClass;
        this.introducedByChangeOfExistingClass = from.introducedByChangeOfExistingClass;
    }

    public void setLastVersion(long lastVersion) {
        if (lastVersion >= 0L && this.firstVersion > lastVersion) {
            throw new IllegalArgumentException(this.firstVersion + ".." + lastVersion);
        }
        this.lastVersion = lastVersion;
    }

    public void setLive() {
        this.lastVersion = -1L;
    }

    public long getLastVersion() {
        return this.lastVersion;
    }

    public boolean isDead() {
        return this.lastVersion != -1L;
    }

    public void setIntroducedByChangeOfExistingClass(boolean introducedByChangeOfExistingClass) {
        this.introducedByChangeOfExistingClass = introducedByChangeOfExistingClass;
    }

    public boolean isIntroducedByChangeOfExistingClass() {
        return this.introducedByChangeOfExistingClass;
    }

    public void setRemovedByChangeOfPersistingClass(boolean removedByChangeOfPersistingClass) {
        this.removedByChangeOfPersistingClass = removedByChangeOfPersistingClass;
    }

    public boolean isRemovedByChangeOfPersistingClass() {
        return this.removedByChangeOfPersistingClass;
    }

    public void setInstanceHash(String instanceHash) {
        this.instanceHash = instanceHash;
    }

    public void setOldInstanceHash(String oldInstanceHash) {
        this.oldInstanceHash = oldInstanceHash;
    }

    public String getInstanceHash() {
        byte[] data;
        String hash = this.instanceHash;
        if (hash != null) {
            return hash;
        }
        MessageDigest digest = Util.getMD5Digest();
        String key = this.getInstanceKey();
        try {
            data = digest.digest(key.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.instanceHash = hash = new BigInteger(1, data).toString(16);
        return hash;
    }

    public boolean isInstanceHashConsistent() {
        return this.oldInstanceHash == null || this.getInstanceHash().equals(this.oldInstanceHash);
    }

    public void setInstanceOccurrenceNum(int instanceOccurrenceNum) {
        this.instanceOccurrenceNum = instanceOccurrenceNum;
    }

    public int getInstanceOccurrenceNum() {
        return this.instanceOccurrenceNum;
    }

    public void setInstanceOccurrenceMax(int instanceOccurrenceMax) {
        this.instanceOccurrenceMax = instanceOccurrenceMax;
    }

    public int getInstanceOccurrenceMax() {
        return this.instanceOccurrenceMax;
    }

    @CheckForNull
    public DetectorFactory getDetectorFactory() {
        return this.detectorFactory;
    }

    private void optionalAdd(Collection<BugAnnotation> c, BugAnnotation a) {
        if (a != null) {
            c.add(a);
        }
    }

    public List<BugAnnotation> getAnnotationsForMessage(boolean showContext) {
        ArrayList<BugAnnotation> result = new ArrayList<BugAnnotation>();
        HashSet<BugAnnotation> primaryAnnotations = new HashSet<BugAnnotation>();
        FieldAnnotation primeField = this.getPrimaryField();
        MethodAnnotation primeMethod = this.getPrimaryMethod();
        ClassAnnotation primeClass = this.getPrimaryClass();
        SourceLineAnnotation primarySourceLineAnnotation = this.getPrimarySourceLineAnnotation();
        this.optionalAdd(primaryAnnotations, primarySourceLineAnnotation);
        this.optionalAdd(primaryAnnotations, primeMethod);
        this.optionalAdd(primaryAnnotations, primeField);
        this.optionalAdd(primaryAnnotations, primeClass);
        if (showContext || !"SOURCE_LINE_DEFAULT".equals(primarySourceLineAnnotation.getDescription())) {
            result.add(primarySourceLineAnnotation);
        }
        if (primeMethod != null && (showContext || !"METHOD_DEFAULT".equals(primeMethod.getDescription()))) {
            result.add(primeMethod);
        }
        this.optionalAdd(result, primeField);
        String fieldClass = "";
        String methodClass = "";
        if (primeField != null) {
            fieldClass = primeField.getClassName();
        }
        if (primeMethod != null) {
            methodClass = primeMethod.getClassName();
        }
        if (showContext && primaryAnnotations.size() < 2 || !primeClass.getClassName().equals(fieldClass) && !primeClass.getClassName().equals(methodClass)) {
            this.optionalAdd(result, primeClass);
        }
        for (BugAnnotation bugAnnotation : this.getAnnotations()) {
            if (primaryAnnotations.contains(bugAnnotation) || bugAnnotation instanceof LocalVariableAnnotation && !((LocalVariableAnnotation)bugAnnotation).isNamed() || bugAnnotation instanceof SourceLineAnnotation && ((SourceLineAnnotation)bugAnnotation).isUnknown()) continue;
            result.add(bugAnnotation);
        }
        return result;
    }

    static {
        missingBugTypes = Collections.synchronizedSet(new HashSet());
    }

    private class BugPropertyIterator
    implements Iterator<BugProperty> {
        private BugProperty prev;
        private BugProperty cur;
        private boolean removed;

        private BugPropertyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        @Override
        public BugProperty next() {
            BugProperty next = this.findNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.cur;
            this.cur = next;
            this.removed = false;
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == null || this.removed) {
                throw new IllegalStateException();
            }
            if (this.prev == null) {
                BugInstance.this.propertyListHead = this.cur.getNext();
            } else {
                this.prev.setNext(this.cur.getNext());
            }
            if (this.cur == BugInstance.this.propertyListTail) {
                BugInstance.this.propertyListTail = this.prev;
            }
            this.removed = true;
        }

        private BugProperty findNext() {
            return this.cur == null ? BugInstance.this.propertyListHead : this.cur.getNext();
        }
    }

    public static class NoSuchBugPattern
    extends IllegalArgumentException {
        public final String type;

        public NoSuchBugPattern(String type) {
            super("Can't find definition of bug type " + type);
            this.type = type;
        }
    }
}

