/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

public abstract class FindBugsCommandLine
extends CommandLine {
    protected AnalysisFeatureSetting[] settingList = FindBugs.DEFAULT_EFFORT;
    protected Project project = new Project();
    protected boolean projectLoadedFromFile;

    public FindBugsCommandLine() {
        this.startOptionGroup("General FindBugs options:");
        this.addOption("-project", "project", "analyze given project");
        this.addOption("-home", "home directory", "specify SpotBugs home directory");
        this.addOption("-pluginList", "jar1[" + File.pathSeparator + "jar2...]", "specify list of plugin Jar files to load");
        this.addSwitchWithOptionalExtraPart("-effort", "min|less|default|more|max", "set analysis effort level");
        this.addSwitch("-adjustExperimental", "lower priority of experimental Bug Patterns");
        this.addSwitch("-workHard", "ensure analysis effort is at least 'default'");
        this.addSwitch("-conserveSpace", "same as -effort:min (for backward compatibility)");
    }

    public FindBugsCommandLine(boolean modernGui) {
        this();
        this.addOption("-f", "font size", "set font size");
        this.addSwitch("-clear", "clear saved GUI settings and exit");
        this.addOption("-priority", "thread priority", "set analysis thread priority");
        this.addOption("-loadbugs", "saved analysis results", "load bugs from saved analysis results");
        this.makeOptionUnlisted("-loadbugs");
        this.addOption("-loadBugs", "saved analysis results", "load bugs from saved analysis results");
        this.addSwitch("-d", "disable docking");
        this.addSwitch("--nodock", "disable docking");
        this.addSwitchWithOptionalExtraPart("-look", "plastic|gtk|native", "set UI look and feel");
    }

    public AnalysisFeatureSetting[] getSettingList() {
        return this.settingList;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    public boolean isProjectLoadedFromFile() {
        return this.projectLoadedFromFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleOption(String option, String optionExtraPart) {
        if ("-effort".equals(option)) {
            if ("min".equals(optionExtraPart)) {
                this.settingList = FindBugs.MIN_EFFORT;
                return;
            } else if ("less".equals(optionExtraPart)) {
                this.settingList = FindBugs.LESS_EFFORT;
                return;
            } else if ("default".equals(optionExtraPart)) {
                this.settingList = FindBugs.DEFAULT_EFFORT;
                return;
            } else if ("more".equals(optionExtraPart)) {
                this.settingList = FindBugs.MORE_EFFORT;
                return;
            } else {
                if (!"max".equals(optionExtraPart)) throw new IllegalArgumentException("-effort:<value> must be one of min,default,more,max");
                this.settingList = FindBugs.MAX_EFFORT;
            }
            return;
        } else if ("-workHard".equals(option)) {
            if (this.settingList == FindBugs.MAX_EFFORT) return;
            this.settingList = FindBugs.MORE_EFFORT;
            return;
        } else if ("-conserveSpace".equals(option)) {
            this.settingList = FindBugs.MIN_EFFORT;
            return;
        } else {
            if (!"-adjustExperimental".equals(option)) throw new IllegalArgumentException("Don't understand option " + option);
            BugInstance.setAdjustExperimental(true);
        }
    }

    @Override
    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if ("-home".equals(option)) {
            FindBugs.setHome(argument);
        } else if ("-pluginList".equals(option)) {
            String pluginListStr = argument;
            Map<String, Boolean> customPlugins = this.getProject().getConfiguration().getCustomPlugins();
            StringTokenizer tok = new StringTokenizer(pluginListStr, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File file = new File(tok.nextToken());
                Boolean enabled = file.isFile();
                customPlugins.put(file.getAbsolutePath(), enabled);
                if (!enabled.booleanValue()) continue;
                try {
                    Plugin.loadCustomPlugin(file, this.getProject());
                }
                catch (PluginException e) {
                    throw new IllegalStateException("Failed to load plugin specified by the '-pluginList', file: " + file, e);
                }
            }
        } else if ("-project".equals(option)) {
            this.loadProject(argument);
        } else {
            throw new IllegalStateException();
        }
    }

    public void loadProject(String arg) throws IOException {
        Project newProject = Project.readProject(arg);
        newProject.setConfiguration(this.project.getConfiguration());
        this.project = newProject;
        this.projectLoadedFromFile = true;
    }
}

