/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.Collection;
import java.util.HashSet;

public final class LockSet {
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    private static final int INVALID = -1;
    private static final int DEFAULT_CAPACITY = 8;
    private int[] array = new int[8];
    private int defaultLockCount = -1;

    public LockSet() {
        this.clear();
    }

    public int getLockCount(int valueNumber) {
        int index = this.findIndex(valueNumber);
        if (index < 0) {
            return this.defaultLockCount;
        }
        return this.array[index + 1];
    }

    public boolean isTop() {
        return this.defaultLockCount == -1;
    }

    public void setLockCount(int valueNumber, int lockCount) {
        int index = this.findIndex(valueNumber);
        if (index < 0) {
            this.addEntry(index, valueNumber, lockCount);
        } else {
            this.array[index + 1] = lockCount;
        }
    }

    public void setDefaultLockCount(int defaultLockCount) {
        this.defaultLockCount = defaultLockCount;
    }

    public int getNumLockedObjects() {
        int result = 0;
        int i = 0;
        while (i + 1 < this.array.length && this.array[i] != -1) {
            if (this.array[i + 1] > 0) {
                ++result;
            }
            i += 2;
        }
        return result;
    }

    public void copyFrom(LockSet other) {
        if (other.array.length != this.array.length) {
            this.array = new int[other.array.length];
        }
        System.arraycopy(other.array, 0, this.array, 0, this.array.length);
        this.defaultLockCount = other.defaultLockCount;
    }

    public void clear() {
        for (int i = 0; i < this.array.length; i += 2) {
            this.array[i] = -1;
        }
    }

    public void meetWith(LockSet other) {
        int his;
        int mine;
        int valueNumber;
        int i = 0;
        while (i + 1 < this.array.length && (valueNumber = this.array[i]) >= 0) {
            mine = this.array[i + 1];
            his = other.getLockCount(valueNumber);
            this.array[i + 1] = LockSet.mergeValues(mine, his);
            i += 2;
        }
        i = 0;
        while (i + 1 < other.array.length && (valueNumber = other.array[i]) >= 0) {
            mine = this.getLockCount(valueNumber);
            his = other.array[i + 1];
            this.setLockCount(valueNumber, LockSet.mergeValues(mine, his));
            i += 2;
        }
        this.setDefaultLockCount(0);
    }

    public boolean sameAs(LockSet other) {
        return this.identicalSubset(other) && other.identicalSubset(this);
    }

    public boolean containsReturnValue(ValueNumberFactory factory) {
        int valueNumber;
        int i = 0;
        while (i + 1 < this.array.length && (valueNumber = this.array[i]) >= 0) {
            int lockCount = this.array[i + 1];
            if (lockCount > 0 && factory.forNumber(valueNumber).hasFlag(1)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public void intersectWith(LockSet other) {
        int valueNumber;
        int i = 0;
        while (i + 1 < this.array.length && (valueNumber = this.array[i]) >= 0) {
            int otherLockCount;
            int myLockCount = this.array[i + 1];
            if (myLockCount > 0 && (otherLockCount = other.getLockCount(valueNumber)) <= 0) {
                this.array[i + 1] = 0;
            }
            i += 2;
        }
    }

    public boolean isEmpty() {
        int i = 0;
        while (i + 1 < this.array.length) {
            int valueNumber = this.array[i];
            if (valueNumber < 0) {
                return true;
            }
            int myLockCount = this.array[i + 1];
            if (myLockCount > 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private boolean identicalSubset(LockSet other) {
        int valueNumber;
        int i = 0;
        while (i + 1 < this.array.length && (valueNumber = this.array[i]) >= 0) {
            int mine = this.array[i + 1];
            int his = other.getLockCount(valueNumber);
            if (mine != his) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private static int mergeValues(int a, int b) {
        if (a == -1) {
            return b;
        }
        if (b == -1) {
            return a;
        }
        if (a == -2 || b == -2) {
            return -2;
        }
        if (a == b) {
            return a;
        }
        return -2;
    }

    private int findIndex(int valueNumber) {
        for (int i = 0; i < this.array.length; i += 2) {
            int value = this.array[i];
            if (value < 0) {
                return -(i + 1);
            }
            if (value != valueNumber) continue;
            return i;
        }
        return -(this.array.length + 1);
    }

    private void addEntry(int negatedIndex, int valueNumber, int lockCount) {
        int index = -(negatedIndex + 1);
        int origCapacity = this.array.length;
        if (index == origCapacity) {
            int[] data = new int[origCapacity * 2];
            System.arraycopy(this.array, 0, data, 0, origCapacity);
            for (int i = index + 2; i < data.length; i += 2) {
                data[i] = -1;
            }
            this.array = data;
        }
        this.array[index] = valueNumber;
        this.array[index + 1] = lockCount;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        boolean first = true;
        if (this.defaultLockCount == 0) {
            buf.append("default=0");
            first = false;
        }
        int i = 0;
        while (i + 1 < this.array.length) {
            int lockCount;
            int valueNumber = this.array[i];
            if (valueNumber >= 0 && (lockCount = this.array[i + 1]) != 0) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(valueNumber);
                buf.append('=');
                if (lockCount == -1) {
                    buf.append("TOP");
                } else if (lockCount == -2) {
                    buf.append("BOTTOM");
                } else {
                    buf.append(lockCount);
                }
            }
            i += 2;
        }
        buf.append(']');
        return buf.toString();
    }

    public Collection<ValueNumber> getLockedValueNumbers(ValueNumberFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("Null Frame");
        }
        HashSet<ValueNumber> result = new HashSet<ValueNumber>();
        for (ValueNumber v : frame.allSlots()) {
            if (v == null || this.getLockCount(v.getNumber()) <= 0) continue;
            result.add(v);
        }
        return result;
    }
}

