/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.FieldAccess;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.Variable;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

public class Store
extends FieldAccess {
    public Store(String fieldVarName, String valueVarName) {
        super(fieldVarName, valueVarName);
    }

    @Override
    public MatchResult match(InstructionHandle handle, ConstantPoolGen cpg, ValueNumberFrame before, ValueNumberFrame after, BindingSet bindingSet) throws DataflowAnalysisException {
        FieldVariable field;
        PUTFIELD fieldIns;
        Instruction ins = handle.getInstruction();
        if (ins instanceof PUTFIELD) {
            fieldIns = (PUTFIELD)ins;
            int numSlots = before.getNumSlots();
            ValueNumber ref = (ValueNumber)before.getValue(Store.isLongOrDouble((FieldInstruction)fieldIns, cpg) ? numSlots - 3 : numSlots - 2);
            field = new FieldVariable(ref, fieldIns.getClassName(cpg), fieldIns.getFieldName(cpg), fieldIns.getSignature(cpg));
        } else if (ins instanceof PUTSTATIC) {
            fieldIns = (PUTSTATIC)ins;
            field = new FieldVariable(fieldIns.getClassName(cpg), fieldIns.getFieldName(cpg), fieldIns.getSignature(cpg));
        } else {
            return null;
        }
        Variable value = Store.snarfFieldValue((FieldInstruction)fieldIns, cpg, before);
        return this.checkConsistent(field, value, bindingSet);
    }
}

