/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.RecursiveFileSearch;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.DirectoryCodeBaseEntry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class DirectoryCodeBase
extends AbstractScannableCodeBase {
    private File directory;
    private RecursiveFileSearch rfs;
    private boolean searchPerformed;

    public DirectoryCodeBase(ICodeBaseLocator codeBaseLocator, File directory) {
        super(codeBaseLocator);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.directory = directory;
        this.rfs = new RecursiveFileSearch(directory.getPath(), pathname -> true);
        this.searchPerformed = false;
    }

    @Override
    public ICodeBaseIterator iterator() throws InterruptedException {
        if (!this.searchPerformed) {
            this.rfs.search();
            this.searchPerformed = true;
        }
        return new DirectoryCodeBaseIterator();
    }

    @Override
    public String getPathName() {
        return this.directory.getPath();
    }

    @Override
    public void close() {
    }

    @Override
    public ICodeBaseEntry lookupResource(String resourceName) {
        File file = this.getFullPathOfResource(resourceName = this.translateResourceName(resourceName));
        if (!file.exists()) {
            return null;
        }
        return new DirectoryCodeBaseEntry(this, resourceName);
    }

    InputStream openFile(String resourceName) throws FileNotFoundException, IOException {
        File path = this.getFullPathOfResource(resourceName);
        return new BufferedInputStream(new FileInputStream(path));
    }

    File getFullPathOfResource(String resourceName) {
        return new File(this.directory, resourceName);
    }

    String getResourceName(String fileName) {
        String dirPath = this.directory.getPath();
        if (!fileName.startsWith(dirPath)) {
            throw new IllegalStateException("Filename " + fileName + " not inside directory " + dirPath);
        }
        String relativeFileName = fileName.substring(dirPath.length());
        File file = new File(relativeFileName);
        LinkedList<String> partList = new LinkedList<String>();
        do {
            partList.addFirst(file.getName());
        } while ((file = file.getParentFile()) != null);
        StringBuilder buf = new StringBuilder();
        for (String part : partList) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(part);
        }
        return buf.toString();
    }

    public String toString() {
        return this.directory.getPath();
    }

    private class DirectoryCodeBaseIterator
    implements ICodeBaseIterator {
        Iterator<String> fileNameIterator;

        private DirectoryCodeBaseIterator() {
            this.fileNameIterator = DirectoryCodeBase.this.rfs.fileNameIterator();
        }

        @Override
        public boolean hasNext() throws InterruptedException {
            return this.fileNameIterator.hasNext();
        }

        @Override
        public ICodeBaseEntry next() throws InterruptedException {
            String fileName = this.fileNameIterator.next();
            String resourceName = DirectoryCodeBase.this.getResourceName(fileName);
            File file = new File(fileName);
            long modTime = file.lastModified();
            DirectoryCodeBase.this.addLastModifiedTime(modTime);
            return new DirectoryCodeBaseEntry(DirectoryCodeBase.this, resourceName);
        }
    }
}

