/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;

public class CovariantArrayAssignment
extends OpcodeStackDetector {
    private final BugAccumulator accumulator;

    public CovariantArrayAssignment(BugReporter bugReporter) {
        this.accumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.accumulator.reportAccumulatedBugs();
    }

    private static boolean allImplementationsDerivedFromSubclass(@SlashedClassName String superClass, @SlashedClassName String subClass) {
        ClassDescriptor superDescriptor = DescriptorFactory.createClassDescriptor(superClass);
        XClass xClass = AnalysisContext.currentXFactory().getXClass(superDescriptor);
        if (xClass == null || !xClass.isInterface() && !xClass.isAbstract()) {
            return false;
        }
        try {
            ClassDescriptor wantedDescriptor = DescriptorFactory.createClassDescriptor(subClass);
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            for (ClassDescriptor subDescriptor : subtypes2.getSubtypes(superDescriptor)) {
                XClass xSubClass;
                if (subDescriptor.equals(superDescriptor) || subDescriptor.equals(wantedDescriptor) || (xSubClass = AnalysisContext.currentXFactory().getXClass(subDescriptor)) != null && (xSubClass.isAbstract() || xSubClass.isInterface() || subtypes2.isSubtype(subDescriptor, wantedDescriptor))) continue;
                return false;
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        String arraySignature;
        OpcodeStack.Item valueItem;
        if ((this.isRegisterStore() && !this.isRegisterLoad() || seen == 181 || seen == 179 || seen == 176) && !(valueItem = this.getStack().getStackItem(0)).isNull() && valueItem.isNewlyAllocated() && valueItem.getSignature().startsWith("[L") && !Integer.valueOf(0).equals(valueItem.getConstant())) {
            String arrayClass;
            String valueClass = valueItem.getSignature().substring(2, valueItem.getSignature().length() - 1);
            arraySignature = null;
            int priority = 3;
            String pattern = null;
            FieldDescriptor field = null;
            if (seen == 181 || seen == 179) {
                XClass xClass;
                XField xField;
                arraySignature = this.getSigConstantOperand();
                pattern = "CAA_COVARIANT_ARRAY_FIELD";
                field = this.getFieldDescriptorOperand();
                if (field instanceof XField && ((xField = (XField)((Object)field)).isPublic() || xField.isProtected()) && (xClass = AnalysisContext.currentXFactory().getXClass(xField.getClassDescriptor())) != null && xClass.isPublic()) {
                    priority = 2;
                }
            } else if (seen == 176) {
                if (this.getXMethod().bridgeFrom() == null) {
                    pattern = "CAA_COVARIANT_ARRAY_RETURN";
                    arraySignature = new SignatureParser(this.getMethodSig()).getReturnTypeSignature();
                    if (!arraySignature.equals("[Ljava/lang/Object;") && (this.getXMethod().isPublic() || this.getXMethod().isProtected()) && this.getXClass().isPublic()) {
                        priority = 2;
                    }
                }
            } else {
                LocalVariable localVariable;
                LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
                if (lvt != null && (localVariable = lvt.getLocalVariable(this.getRegisterOperand(), this.getNextPC())) != null) {
                    pattern = "CAA_COVARIANT_ARRAY_LOCAL";
                    arraySignature = localVariable.getSignature();
                }
            }
            if (arraySignature != null && arraySignature.startsWith("[L") && !valueClass.equals(arrayClass = arraySignature.substring(2, arraySignature.length() - 1))) {
                if (priority == 2 && CovariantArrayAssignment.allImplementationsDerivedFromSubclass(arrayClass, valueClass)) {
                    priority = 3;
                }
                BugInstance bug = new BugInstance(this, pattern, priority).addClassAndMethod(this).addFoundAndExpectedType(valueItem.getSignature(), arraySignature).addSourceLine(this).addValueSource(valueItem, this);
                if (field != null) {
                    bug.addField(field);
                }
                this.accumulator.accumulateBug(bug, this);
            }
        }
        if (seen == 83 && !(valueItem = this.getStack().getStackItem(0)).isNull()) {
            OpcodeStack.Item arrayItem = this.getStack().getStackItem(2);
            arraySignature = arrayItem.getSignature();
            String valueSignature = valueItem.getSignature();
            if (arraySignature.startsWith("[L") && valueSignature.startsWith("L") && !valueSignature.equals("Ljava/lang/Object;")) {
                String arrayClass = arraySignature.substring(2, arraySignature.length() - 1);
                String valueClass = valueSignature.substring(1, valueSignature.length() - 1);
                try {
                    ClassDescriptor valueClassDescriptor = DescriptorFactory.createClassDescriptor(valueClass);
                    ClassDescriptor arrayClassDescriptor = DescriptorFactory.createClassDescriptor(arrayClass);
                    if (!AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(valueClassDescriptor, arrayClassDescriptor)) {
                        int priority = 1;
                        if (AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(arrayClassDescriptor, valueClassDescriptor)) {
                            priority = 2;
                            if (CovariantArrayAssignment.allImplementationsDerivedFromSubclass(valueClass, arrayClass)) {
                                priority = 5;
                            }
                        }
                        BugInstance bug = new BugInstance(this, "CAA_COVARIANT_ARRAY_ELEMENT_STORE", priority).addClassAndMethod(this).addFoundAndExpectedType(valueSignature, 'L' + arrayClass + ';').addSourceLine(this).addValueSource(valueItem, this).addValueSource(arrayItem, this);
                        this.accumulator.accumulateBug(bug, this);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }
}

