/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckBoxList<E>
extends JList<E> {
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    public CheckBoxList(E[] list) {
        this();
        this.setListData(list);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ((JCheckBox)this.getModel().getElementAt(i)).setEnabled(enabled);
        }
    }

    protected class CellRenderer
    implements ListCellRenderer<E> {
        protected CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = (JCheckBox)value;
            checkbox.setBackground(isSelected ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
            checkbox.setForeground(isSelected ? CheckBoxList.this.getSelectionForeground() : CheckBoxList.this.getForeground());
            checkbox.setEnabled(CheckBoxList.this.isEnabled());
            checkbox.setFont(CheckBoxList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return checkbox;
        }
    }
}

