/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.util.ArrayList;
import java.util.Arrays;

public class AnalysisError {
    private static final int PRIME = 31;
    private String message;
    private String exceptionMessage;
    private String[] stackTrace;
    private String nestedExceptionMessage;
    private String[] nestedStackTrace;
    private final Throwable exception;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.exceptionMessage == null ? 0 : this.exceptionMessage.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.nestedExceptionMessage == null ? 0 : this.nestedExceptionMessage.hashCode());
        result = 31 * result + Arrays.hashCode(this.nestedStackTrace);
        result = 31 * result + Arrays.hashCode(this.stackTrace);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisError)) {
            return false;
        }
        AnalysisError other = (AnalysisError)obj;
        if (this.exceptionMessage == null ? other.exceptionMessage != null : !this.exceptionMessage.equals(other.exceptionMessage)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.nestedExceptionMessage == null ? other.nestedExceptionMessage != null : !this.nestedExceptionMessage.equals(other.nestedExceptionMessage)) {
            return false;
        }
        if (!Arrays.equals(this.nestedStackTrace, other.nestedStackTrace)) {
            return false;
        }
        return Arrays.equals(this.stackTrace, other.stackTrace);
    }

    public AnalysisError(String message) {
        this(message, null);
    }

    public AnalysisError(String message, Throwable exception) {
        this.message = message;
        this.exception = exception;
        if (exception != null) {
            this.exceptionMessage = exception.toString();
            this.stackTrace = this.getStackTraceAsStringArray(exception);
            Throwable initCause = exception.getCause();
            if (initCause != null) {
                this.nestedExceptionMessage = initCause.toString();
                this.nestedStackTrace = this.getStackTraceAsStringArray(initCause);
            }
        }
    }

    private String[] getStackTraceAsStringArray(Throwable exception) {
        StackTraceElement[] exceptionStackTrace = exception.getStackTrace();
        ArrayList<String> arr = new ArrayList<String>();
        for (StackTraceElement aExceptionStackTrace : exceptionStackTrace) {
            arr.add(aExceptionStackTrace.toString());
        }
        String[] tmp = arr.toArray(new String[arr.size()]);
        return tmp;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getNestedExceptionMessage() {
        return this.nestedExceptionMessage;
    }

    public void setStackTrace(String[] stackTraceList) {
        this.stackTrace = stackTraceList;
    }

    public String[] getStackTrace() {
        return this.stackTrace;
    }

    public String[] getNestedStackTrace() {
        return this.nestedStackTrace;
    }

    public Throwable getException() {
        return this.exception;
    }
}

