/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.SystemProperties;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassScreener
implements IClassScreener {
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.classscreener.debug");
    private static final String SEP = "[/\\\\]";
    private static final String START = "(?:^|[/\\\\])";
    private static final String JAVA_IDENTIFIER_PART = "[^./\\\\]";
    private final LinkedList<Matcher> patternList = new LinkedList();

    private static String dotsToRegex(String dotsName) {
        String tmp = dotsName.replace("$", "\\$");
        return tmp.replace(".", SEP);
    }

    public void addAllowedClass(String className) {
        String classRegex = START + ClassScreener.dotsToRegex(className) + ".class$";
        if (DEBUG) {
            System.out.println("Class regex: " + classRegex);
        }
        this.patternList.add(Pattern.compile(classRegex).matcher(""));
    }

    public void addAllowedPackage(String packageName) {
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        String packageRegex = START + ClassScreener.dotsToRegex(packageName) + SEP + JAVA_IDENTIFIER_PART + "+.class$";
        if (DEBUG) {
            System.out.println("Package regex: " + packageRegex);
        }
        this.patternList.add(Pattern.compile(packageRegex).matcher(""));
    }

    public void addAllowedPrefix(String prefix) {
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (DEBUG) {
            System.out.println("Allowed prefix: " + prefix);
        }
        String packageRegex = START + ClassScreener.dotsToRegex(prefix) + SEP;
        if (DEBUG) {
            System.out.println("Prefix regex: " + packageRegex);
        }
        this.patternList.add(Pattern.compile(packageRegex).matcher(""));
    }

    @Override
    public boolean matches(String fileName) {
        if (this.patternList.isEmpty()) {
            return true;
        }
        if (DEBUG) {
            System.out.println("Matching: " + fileName);
        }
        for (Matcher matcher : this.patternList) {
            if (DEBUG) {
                System.out.print("\tTrying [" + matcher.pattern());
            }
            matcher.reset(fileName);
            if (matcher.find()) {
                if (DEBUG) {
                    System.out.println("]: yes!");
                }
                return true;
            }
            if (!DEBUG) continue;
            System.out.println("]: no");
        }
        return false;
    }

    @Override
    public boolean vacuous() {
        return this.patternList.isEmpty();
    }
}

