/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.ExcludingHashesBugReporter;
import edu.umd.cs.findbugs.FilterBugReporter;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.InterproceduralFirstPassDetector;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ShowHelp;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.DocumentException;

public abstract class FindBugs {
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"}, justification="Would have to break APIs to fix this properly")
    public static final AnalysisFeatureSetting[] MIN_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, true), new AnalysisFeatureSetting(0, false), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, false), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, false), new AnalysisFeatureSetting(6, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"}, justification="Would have to break APIs to fix this properly")
    public static final AnalysisFeatureSetting[] LESS_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, false), new AnalysisFeatureSetting(6, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"}, justification="Would have to break APIs to fix this properly")
    public static final AnalysisFeatureSetting[] DEFAULT_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"}, justification="Would have to break APIs to fix this properly")
    public static final AnalysisFeatureSetting[] MORE_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"}, justification="Would have to break APIs to fix this properly")
    public static final AnalysisFeatureSetting[] MAX_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, false), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, true)};
    public static final boolean DEBUG = Boolean.getBoolean("findbugs.debug");
    private static String home = System.getProperty("spotbugs.home", System.getProperty("findbugs.home"));
    private static boolean noAnalysis = Boolean.getBoolean("findbugs.noAnalysis");
    private static boolean noMains = Boolean.getBoolean("findbugs.noMains");
    public static final Logger LOGGER = Logger.getLogger(FindBugs.class.getPackage().getName());
    @StaticConstant
    public static final Set<String> knownURLProtocolSet;
    public static final long MINIMUM_TIMESTAMP;

    public static void setNoAnalysis() {
        noAnalysis = true;
    }

    public static boolean isNoAnalysis() {
        return noAnalysis;
    }

    public static void setNoMains() {
        noMains = true;
    }

    public static boolean isNoMains() {
        return noMains;
    }

    public static void setHome(String home) {
        FindBugs.home = home;
    }

    public static String getHome() {
        return home;
    }

    public static void configureTrainingDatabases(IFindBugsEngine findBugs) throws IOException {
        if (findBugs.emitTrainingOutput()) {
            String trainingOutputDir = findBugs.getTrainingOutputDir();
            if (!new File(trainingOutputDir).isDirectory()) {
                throw new IOException("Training output directory " + trainingOutputDir + " does not exist");
            }
            AnalysisContext.currentAnalysisContext().setDatabaseOutputDir(trainingOutputDir);
            System.setProperty("findbugs.checkreturn.savetraining", new File(trainingOutputDir, "checkReturn.db").getPath());
        }
        if (findBugs.useTrainingInput()) {
            String trainingInputDir = findBugs.getTrainingInputDir();
            if (!new File(trainingInputDir).isDirectory()) {
                throw new IOException("Training input directory " + trainingInputDir + " does not exist");
            }
            AnalysisContext.currentAnalysisContext().setDatabaseInputDir(trainingInputDir);
            AnalysisContext.currentAnalysisContext().loadInterproceduralDatabases();
            System.setProperty("findbugs.checkreturn.loadtraining", new File(trainingInputDir, "checkReturn.db").getPath());
        } else {
            AnalysisContext.currentAnalysisContext().loadDefaultInterproceduralDatabases();
        }
    }

    public static boolean isDetectorEnabled(IFindBugsEngine findBugs, DetectorFactory factory, int rankThreshold) {
        if (!findBugs.getUserPreferences().isDetectorEnabled(factory)) {
            return false;
        }
        if (!factory.isEnabledForCurrentJRE()) {
            return false;
        }
        if (!AnalysisContext.currentAnalysisContext().getBoolProperty(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS) && factory.isDetectorClassSubtypeOf(InterproceduralFirstPassDetector.class)) {
            return false;
        }
        int maxRank = Integer.MAX_VALUE;
        Set<BugPattern> reportedBugPatterns = factory.getReportedBugPatterns();
        boolean isNonReportingDetector = factory.isDetectorClassSubtypeOf(FirstPassDetector.class);
        if (!isNonReportingDetector && !reportedBugPatterns.isEmpty()) {
            for (BugPattern b : reportedBugPatterns) {
                int rank = BugRanker.findRank(b, factory);
                if (maxRank <= rank) continue;
                maxRank = rank;
            }
            if (maxRank > rankThreshold) {
                return false;
            }
        }
        boolean isTrainingDetector = factory.isDetectorClassSubtypeOf(TrainingDetector.class);
        if (findBugs.emitTrainingOutput()) {
            return isTrainingDetector || isNonReportingDetector;
        }
        return !isTrainingDetector;
    }

    public static Set<String> handleBugCategories(String categories) {
        HashSet<String> categorySet = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(categories, ",");
        while (tok.hasMoreTokens()) {
            categorySet.add(tok.nextToken());
        }
        return categorySet;
    }

    public static void processCommandLine(TextUICommandLine commandLine, String[] argv, IFindBugsEngine findBugs) throws IOException, FilterException {
        try {
            argv = commandLine.expandOptionFiles(argv, true, true);
        }
        catch (CommandLine.HelpRequestedException e) {
            FindBugs.showHelp(commandLine);
        }
        int argCount = 0;
        try {
            argCount = commandLine.parse(argv);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            FindBugs.showHelp(commandLine);
        }
        catch (CommandLine.HelpRequestedException e) {
            FindBugs.showHelp(commandLine);
        }
        Project project = commandLine.getProject();
        for (int i = argCount; i < argv.length; ++i) {
            project.addFile(argv[i]);
        }
        commandLine.handleXArgs();
        commandLine.configureEngine(findBugs);
        if (commandLine.getProject().getFileCount() == 0 && !commandLine.justPrintConfiguration() && !commandLine.justPrintVersion()) {
            System.out.println("No files to be analyzed");
            FindBugs.showHelp(commandLine);
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public static void showHelp(TextUICommandLine commandLine) {
        FindBugs.showSynopsis();
        ShowHelp.showGeneralOptions();
        FindBugs.showCommandLineOptions(commandLine);
        System.exit(1);
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public static void runMain(IFindBugsEngine findBugs, TextUICommandLine commandLine) throws IOException {
        boolean verbose = !commandLine.quiet();
        try {
            findBugs.execute();
        }
        catch (InterruptedException e) {
            assert (false);
            FindBugs.checkExitCodeFail(commandLine, e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            FindBugs.checkExitCodeFail(commandLine, e);
            throw e;
        }
        catch (IOException e) {
            FindBugs.checkExitCodeFail(commandLine, e);
            throw e;
        }
        int bugCount = findBugs.getBugCount();
        int missingClassCount = findBugs.getMissingClassCount();
        int errorCount = findBugs.getErrorCount();
        if (verbose || commandLine.setExitCode()) {
            if (bugCount > 0) {
                System.err.println("Warnings generated: " + bugCount);
            }
            if (missingClassCount > 0) {
                System.err.println("Missing classes: " + missingClassCount);
            }
            if (errorCount > 0) {
                System.err.println("Analysis errors: " + errorCount);
            }
        }
        if (commandLine.setExitCode()) {
            int exitCode = 0;
            if (verbose) {
                System.err.println("Calculating exit code...");
            }
            if (errorCount > 0) {
                exitCode |= 4;
                if (verbose) {
                    System.err.println("Setting 'errors encountered' flag (4)");
                }
            }
            if (missingClassCount > 0) {
                exitCode |= 2;
                if (verbose) {
                    System.err.println("Setting 'missing class' flag (2)");
                }
            }
            if (bugCount > 0) {
                exitCode |= 1;
                if (verbose) {
                    System.err.println("Setting 'bugs found' flag (1)");
                }
            }
            if (verbose) {
                System.err.println("Exit code set to: " + exitCode);
            }
            System.exit(exitCode);
        }
    }

    private static void checkExitCodeFail(TextUICommandLine commandLine, Exception e) {
        if (commandLine.setExitCode()) {
            e.printStackTrace(System.err);
            System.exit(4);
        }
    }

    public static void showCommandLineOptions() {
        FindBugs.showCommandLineOptions(new TextUICommandLine());
    }

    public static void showCommandLineOptions(TextUICommandLine commandLine) {
        commandLine.printUsage(System.out);
    }

    public static void showSynopsis() {
        System.out.println("Usage: findbugs [general options] -textui [command line options...] [jar/zip/class files, directories...]");
    }

    public static BugReporter configureFilter(BugReporter bugReporter, String filterFileName, boolean include) throws IOException, FilterException {
        Filter filter = new Filter(filterFileName);
        return new FilterBugReporter(bugReporter, filter, include);
    }

    public static BugReporter configureBaselineFilter(BugReporter bugReporter, String baselineFileName) throws IOException, DocumentException {
        return new ExcludingHashesBugReporter(bugReporter, baselineFileName);
    }

    public static void configureBugCollection(IFindBugsEngine findBugs) {
        BugCollection bugs = findBugs.getBugReporter().getBugCollection();
        if (bugs != null) {
            long timestamp;
            bugs.setReleaseName(findBugs.getReleaseName());
            Project project = findBugs.getProject();
            String projectName = project.getProjectName();
            if (projectName == null) {
                projectName = findBugs.getProjectName();
                project.setProjectName(projectName);
            }
            if (FindBugs.validTimestamp(timestamp = project.getTimestamp())) {
                bugs.setTimestamp(timestamp);
                bugs.getProjectStats().setTimestamp(timestamp);
            }
        }
    }

    public static boolean validTimestamp(long timestamp) {
        return timestamp > MINIMUM_TIMESTAMP;
    }

    static {
        LOGGER.setLevel(Level.WARNING);
        HashSet<String> protocols = new HashSet<String>();
        protocols.add("file");
        protocols.add("http");
        protocols.add("https");
        protocols.add("jar");
        knownURLProtocolSet = Collections.unmodifiableSet(protocols);
        MINIMUM_TIMESTAMP = new GregorianCalendar(1996, 0, 23).getTime().getTime();
    }
}

