/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.ValidatorClassLoader;
import java.lang.annotation.Annotation;
import java.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

final class ValidationSecurityManager
extends SecurityManager {
    static final ValidationSecurityManager INSTANCE = new ValidationSecurityManager();
    static final ValidatorClassLoader VALIDATOR_LOADER = ValidatorClassLoader.INSTANCE;
    private static final ThreadLocal<Boolean> performingValidation;

    public static <A extends Annotation> When sandboxedValidation(A proxy, TypeQualifierValidator<A> v, @CheckForNull Object constantValue) {
        if (performingValidation.get().booleanValue()) {
            throw new IllegalStateException("recursive validation");
        }
        try {
            performingValidation.set(Boolean.TRUE);
            if (TypeQualifierValue.DEBUG_CLASSLOADING) {
                System.out.println("Performing validation in thread " + Thread.currentThread().getName());
            }
            try {
                When result = v.forConstantValue(proxy, constantValue);
                if (!performingValidation.get().booleanValue()) {
                    throw new IllegalStateException("performingValidation not set when validation completes");
                }
                When when = result;
                return when;
            }
            catch (ClassCastException e) {
                Class<?> c = proxy.getClass();
                System.out.println(c.getName() + " extends " + c.getSuperclass().getName());
                for (Class<?> i : c.getInterfaces()) {
                    System.out.println("  " + i.getName());
                }
                throw e;
            }
        }
        finally {
            performingValidation.set(Boolean.FALSE);
            if (TypeQualifierValue.DEBUG_CLASSLOADING) {
                System.out.println("Validation finished in thread " + Thread.currentThread().getName());
            }
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            System.out.println("Checking for " + perm + " permission in thread " + Thread.currentThread().getName());
        }
        if (performingValidation.get().booleanValue() && this.inValidation()) {
            SecurityException e = new SecurityException("No permissions granted while performing JSR-305 validation");
            if (TypeQualifierValue.DEBUG_CLASSLOADING) {
                e.printStackTrace(System.out);
            }
            throw e;
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            System.out.println("Checking for " + perm + " permission with content in thread " + Thread.currentThread().getName());
        }
        if (performingValidation.get().booleanValue() && this.inValidation()) {
            SecurityException e = new SecurityException("No permissions granted while performing JSR-305 validation");
            if (TypeQualifierValue.DEBUG_CLASSLOADING) {
                e.printStackTrace(System.out);
            }
            throw e;
        }
    }

    private ValidationSecurityManager() {
    }

    private boolean inValidation() {
        for (Class<?> c : this.getClassContext()) {
            if (!TypeQualifierValidator.class.isAssignableFrom(c) && c.getClassLoader() != VALIDATOR_LOADER) continue;
            return true;
        }
        return false;
    }

    static {
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            new RuntimeException("Creating ValidationSecurityManager #").printStackTrace();
        }
        performingValidation = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

