/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.Hierarchy;
import org.apache.bcel.classfile.Code;

public class FindRunInvocations
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private boolean alreadySawStart;

    public FindRunInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    private boolean isThread(String clazz) {
        try {
            return Hierarchy.isSubtype(clazz, "java.lang.Thread");
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return false;
        }
    }

    @Override
    public void visit(Code obj) {
        this.alreadySawStart = false;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.alreadySawStart) {
            return;
        }
        if ((seen == 182 || seen == 185) && "()V".equals(this.getSigConstantOperand()) && this.isThread(this.getDottedClassConstantOperand())) {
            if ("start".equals(this.getNameConstantOperand())) {
                this.alreadySawStart = true;
            } else {
                boolean isJustThread;
                boolean bl = isJustThread = !"java.lang.Thread".equals(this.getDottedClassConstantOperand());
                if (this.amVisitingMainMethod() && this.getPC() == this.getCode().getLength() - 4 && isJustThread) {
                    return;
                }
                if ("run".equals(this.getNameConstantOperand())) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "RU_INVOKE_RUN", isJustThread ? 1 : 2).addClassAndMethod(this), this);
                }
            }
        }
    }
}

