/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.CompoundMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.Iterator;

public class NotMatcher
extends CompoundMatcher {
    @Override
    public boolean match(BugInstance bugInstance) {
        if (!this.childIterator().hasNext()) {
            return false;
        }
        Matcher invertedMatcher = this.childIterator().next();
        return !invertedMatcher.match(bugInstance);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        if (this.childIterator().hasNext()) {
            xmlOutput.startTag("Not");
            if (disabled) {
                xmlOutput.addAttribute("disabled", "true");
            }
            Matcher invertedMatcher = this.childIterator().next();
            xmlOutput.stopTag(false);
            invertedMatcher.writeXML(xmlOutput, disabled);
            xmlOutput.closeTag("Not");
        }
    }

    @Override
    public String toString() {
        Matcher invertedMatcher = this.childIterator().hasNext() ? this.childIterator().next() : null;
        String invertedMatcherString = invertedMatcher == null ? "" : invertedMatcher.toString();
        return "Not(" + invertedMatcherString + ")";
    }

    @Override
    public int maxChildren() {
        return 1;
    }

    public Matcher originalMatcher() {
        Iterator<Matcher> childMatchers = this.childIterator();
        if (childMatchers.hasNext()) {
            return childMatchers.next();
        }
        throw new IllegalStateException("Tried to retrieve child matcher of empty NotMatcher");
    }
}

