/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.Attribute;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.Definitions;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefinitionsImpl
implements Definitions {
    private final Logger log = LoggerFactory.getLogger(DefinitionsImpl.class);
    private Map<String, Definition> baseDefinitions;
    private Map<Locale, Map<String, Definition>> localeSpecificDefinitions;

    public DefinitionsImpl() {
        this.baseDefinitions = new HashMap<String, Definition>();
        this.localeSpecificDefinitions = new HashMap<Locale, Map<String, Definition>>();
    }

    public DefinitionsImpl(Map<String, Definition> baseDefinitions, Map<Locale, Map<String, Definition>> localeSpecificDefinitions) {
        this.baseDefinitions = baseDefinitions;
        this.localeSpecificDefinitions = localeSpecificDefinitions;
    }

    @Override
    public Definition getDefinition(String name) {
        return this.baseDefinitions.get(name);
    }

    @Override
    public void addDefinitions(Map<String, Definition> defsMap) {
        this.baseDefinitions.putAll(defsMap);
        this.resolveInheritances();
    }

    @Override
    public void addDefinitions(Map<String, Definition> defsMap, Locale locale) {
        this.localeSpecificDefinitions.put(locale, defsMap);
        this.resolveInheritances(locale);
    }

    @Override
    public Definition getDefinition(String name, Locale locale) {
        Map<String, Definition> localeSpecificMap;
        Definition definition = null;
        if (locale != null && (localeSpecificMap = this.localeSpecificDefinitions.get(locale)) != null) {
            definition = localeSpecificMap.get(name);
        }
        if (definition == null) {
            definition = this.getDefinition(name);
        }
        return definition;
    }

    @Override
    public void resolveInheritances() {
        HashSet<String> alreadyResolvedDefinitions = new HashSet<String>();
        for (Definition definition : this.baseDefinitions.values()) {
            this.resolveInheritance(definition, null, alreadyResolvedDefinitions);
        }
    }

    @Override
    public void resolveInheritances(Locale locale) {
        this.resolveInheritances();
        Map<String, Definition> map = this.localeSpecificDefinitions.get(locale);
        if (map != null) {
            HashSet<String> alreadyResolvedDefinitions = new HashSet<String>();
            for (Definition definition : map.values()) {
                this.resolveInheritance(definition, locale, alreadyResolvedDefinitions);
            }
        }
    }

    @Override
    public void reset() {
        this.baseDefinitions = new HashMap<String, Definition>();
        this.localeSpecificDefinitions = new HashMap<Locale, Map<String, Definition>>();
    }

    @Override
    public Map<String, Definition> getBaseDefinitions() {
        return this.baseDefinitions;
    }

    protected Definition getDefinitionByAttribute(Attribute attr, Locale locale) {
        Definition retValue = null;
        Object attrValue = attr.getValue();
        if (attrValue instanceof String) {
            retValue = this.getDefinition((String)attr.getValue(), locale);
        }
        return retValue;
    }

    protected void resolveInheritance(Definition definition, Locale locale, Set<String> alreadyResolvedDefinitions) {
        if (!definition.isExtending() || alreadyResolvedDefinitions.contains(definition.getName())) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolve definition for child name='" + definition.getName() + "' extends='" + definition.getExtends() + "'.");
        }
        alreadyResolvedDefinitions.add(definition.getName());
        Definition parent = this.getDefinition(definition.getExtends(), locale);
        if (parent == null) {
            String msg = "Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + definition.getExtends() + "'. Please check your description file.";
            this.log.error(msg);
            throw new NoSuchDefinitionException(msg);
        }
        this.resolveInheritance(parent, locale, alreadyResolvedDefinitions);
        definition.inherit((BasicAttributeContext)parent);
    }

    @Deprecated
    protected void overload(Definition parent, Definition child) {
        child.inherit((BasicAttributeContext)parent);
    }
}

