/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.impl.AbstractDataIdGnrService;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgovSequenceIdGnrServiceImpl
extends AbstractDataIdGnrService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovSequenceIdGnrServiceImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BigDecimal getNextBigDecimalIdInner() throws FdlException {
        LOGGER.debug(this.messageSource.getMessage("debug.idgnr.sequenceid.query", (Object[])new String[]{this.query}, Locale.getDefault()));
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(this.query);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                BigDecimal bigDecimal = rs.getBigDecimal(1);
                return bigDecimal;
            }
            LOGGER.error(this.messageSource.getMessage("error.idgnr.sequenceid.notallocate.id", (Object[])new String[0], Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.idgnr.sequenceid.notallocate.id");
        }
        catch (SQLException e) {
            LOGGER.error(this.messageSource.getMessage("error.idgnr.get.connection", (Object[])new String[0], Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.idgnr.get.connection", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected long getNextLongIdInner() throws FdlException {
        LOGGER.debug(this.messageSource.getMessage("debug.idgnr.sequenceid.query", (Object[])new String[]{this.query}, Locale.getDefault()));
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(this.query);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            LOGGER.error(this.messageSource.getMessage("error.idgnr.sequenceid.notallocate.id", (Object[])new String[0], Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.idgnr.sequenceid.notallocate.id");
        }
        catch (SQLException e) {
            LOGGER.error(this.messageSource.getMessage("error.idgnr.get.connection", (Object[])new String[0], Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.idgnr.get.connection", (Throwable)e);
        }
    }
}

