/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.EgovIdGnrService;
import egovframework.rte.fdl.idgnr.EgovIdGnrStrategy;
import egovframework.rte.fdl.idgnr.impl.TimeBasedUUIDGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public class EgovUUIdGnrServiceImpl
implements EgovIdGnrService,
ApplicationContextAware {
    private MessageSource messageSource;
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovUUIdGnrServiceImpl.class);
    private static final String ERROR_STRING = "address in the configuration should be a valid IP or MAC Address";
    private String mAddressId;
    private long hostId;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    @Override
    public BigDecimal getNextBigDecimalId() throws FdlException {
        String newId = this.getNextStringId().replaceAll("-", "");
        BigInteger bi = new BigInteger(newId, 16);
        BigDecimal bd = new BigDecimal(bi);
        return bd;
    }

    @Override
    public byte getNextByteId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Byte"}, null);
    }

    @Override
    public int getNextIntegerId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Integer"}, null);
    }

    @Override
    public long getNextLongId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Long"}, null);
    }

    @Override
    public short getNextShortId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Short"}, null);
    }

    @Override
    public String getNextStringId() throws FdlException {
        return this.getUUId();
    }

    @Override
    public String getNextStringId(EgovIdGnrStrategy strategy) throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"String"}, null);
    }

    @Override
    public String getNextStringId(String strategyId) throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"String"}, null);
    }

    public void setAddress(String address) throws FdlException {
        byte[] addressBytes = new byte[6];
        if (null == address) {
            LOGGER.warn("IDGeneration Service : Using a random number as the base for id's.This is not the best method for many purposes, but may be adequate in some circumstances. Consider using an IP or ethernet (MAC) address if available. ");
            for (int i = 0; i < 6; ++i) {
                addressBytes[i] = (byte)(255.0 * Math.random());
            }
        } else if (address.indexOf(".") > 0) {
            StringTokenizer stok = new StringTokenizer(address, ".");
            if (stok.countTokens() != 4) {
                throw new FdlException(ERROR_STRING);
            }
            addressBytes[0] = -1;
            addressBytes[1] = -1;
            int i = 2;
            try {
                while (stok.hasMoreTokens()) {
                    addressBytes[i++] = Integer.valueOf(stok.nextToken(), 16).byteValue();
                }
            }
            catch (Exception e) {
                throw new FdlException(ERROR_STRING);
            }
        } else if (address.indexOf(":") > 0) {
            StringTokenizer stok = new StringTokenizer(address, ":");
            if (stok.countTokens() != 6) {
                throw new FdlException(ERROR_STRING);
            }
            int i = 0;
            try {
                while (stok.hasMoreTokens()) {
                    addressBytes[i++] = Integer.valueOf(stok.nextToken(), 16).byteValue();
                }
            }
            catch (Exception e) {
                throw new FdlException(ERROR_STRING);
            }
        } else {
            throw new FdlException(ERROR_STRING);
        }
        this.mAddressId = TimeBasedUUIDGenerator.getMacAddressAsString(addressBytes);
        this.hostId = TimeBasedUUIDGenerator.getMacAddressAsLong(addressBytes);
        LOGGER.debug("Address Id : " + this.mAddressId);
    }

    private String getUUId() {
        if (this.mAddressId == null) {
            return UUID.randomUUID().toString();
        }
        return TimeBasedUUIDGenerator.generateId(this.hostId).toString();
    }
}

