/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.property.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbPropertySourceDelegate {
    public static final String PROPERTY_SOURCE_KEY = "PKEY";
    public static final String PROPERTY_SOURCE_VALUE = "PVALUE";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private JdbcTemplate jdbcTemplate;
    private String sql;

    public DbPropertySourceDelegate(DataSource dataSource, String sql) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.sql = sql;
        this.initProperties();
    }

    public void initProperties() {
        List result = this.jdbcTemplate.queryForList(this.sql);
        if (result != null) {
            for (int inx = 0; inx < result.size(); ++inx) {
                Map property = (Map)result.get(inx);
                if (property == null) continue;
                Iterator iterator = property.keySet().iterator();
                String pKey = null;
                String pValue = null;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String data = (String)property.get(key);
                    if (PROPERTY_SOURCE_KEY.equals(key)) {
                        pKey = data;
                        continue;
                    }
                    if (!PROPERTY_SOURCE_VALUE.equals(key)) continue;
                    pValue = data;
                }
                this.properties.put(pKey, pValue);
            }
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

