/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleChainVisitor;

public class RuleChain {
    private final Map<Language, RuleChainVisitor> languageToRuleChainVisitor = new HashMap<Language, RuleChainVisitor>();

    public void add(RuleSet ruleSet) {
        for (Rule r : ruleSet.getRules()) {
            this.add(ruleSet, r);
        }
    }

    private void add(RuleSet ruleSet, Rule rule) {
        RuleChainVisitor visitor = this.getRuleChainVisitor(rule.getLanguage());
        if (visitor != null) {
            visitor.add(ruleSet, rule);
        }
    }

    public void apply(List<Node> nodes, RuleContext ctx, Language language) {
        RuleChainVisitor visitor = this.getRuleChainVisitor(language);
        if (visitor != null) {
            visitor.visitAll(nodes, ctx);
        }
    }

    private RuleChainVisitor getRuleChainVisitor(Language language) {
        RuleChainVisitor visitor = this.languageToRuleChainVisitor.get((Object)language);
        if (visitor == null) {
            if (language.getRuleChainVisitorClass() != null) {
                try {
                    visitor = (RuleChainVisitor)language.getRuleChainVisitorClass().newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Failure to created RuleChainVisitor: " + language.getRuleChainVisitorClass(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failure to created RuleChainVisitor: " + language.getRuleChainVisitorClass(), e);
                }
                this.languageToRuleChainVisitor.put(language, visitor);
            } else {
                throw new IllegalArgumentException("Language does not have a RuleChainVisitor: " + (Object)((Object)language));
            }
        }
        return visitor;
    }
}

