/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.util.database.DBURI;

public class CPDCommandLineInterface {
    private static final Logger LOGGER = Logger.getLogger(CPDCommandLineInterface.class.getName());
    private static final int DUPLICATE_CODE_FOUND = 4;
    public static final String NO_EXIT_AFTER_RUN = "net.sourceforge.pmd.cli.noExit";
    public static final String STATUS_CODE_PROPERTY = "net.sourceforge.pmd.cli.status";
    private static final String progName = "cpd";
    private static final char EOL = '\n';

    public static void setStatusCodeOrExit(int status) {
        if (CPDCommandLineInterface.isExitAfterRunSet()) {
            System.exit(status);
        } else {
            CPDCommandLineInterface.setStatusCode(status);
        }
    }

    private static boolean isExitAfterRunSet() {
        String noExit = System.getenv(NO_EXIT_AFTER_RUN);
        if (noExit == null) {
            noExit = System.getProperty(NO_EXIT_AFTER_RUN);
        }
        return noExit == null;
    }

    private static void setStatusCode(int statusCode) {
        System.setProperty(STATUS_CODE_PROPERTY, Integer.toString(statusCode));
    }

    public static void main(String[] args) {
        CPDConfiguration arguments = new CPDConfiguration();
        JCommander jcommander = new JCommander((Object)arguments);
        jcommander.setProgramName(progName);
        try {
            jcommander.parse(args);
            if (arguments.isHelp()) {
                jcommander.usage();
                System.out.println(CPDCommandLineInterface.buildUsageText());
                CPDCommandLineInterface.setStatusCodeOrExit(1);
                return;
            }
        }
        catch (ParameterException e) {
            jcommander.usage();
            System.out.println(CPDCommandLineInterface.buildUsageText());
            System.out.println(e.getMessage());
            CPDCommandLineInterface.setStatusCodeOrExit(1);
            return;
        }
        arguments.postContruct();
        CPDConfiguration.setSystemProperties(arguments);
        CPD cpd = new CPD(arguments);
        if (null != arguments.getFiles() && !arguments.getFiles().isEmpty()) {
            CPDCommandLineInterface.addSourcesFilesToCPD(arguments.getFiles(), cpd, !arguments.isNonRecursive());
        }
        if (null != arguments.getURI() && !"".equals(arguments.getURI())) {
            CPDCommandLineInterface.addSourceURIToCPD(arguments.getURI(), cpd);
        }
        cpd.go();
        if (cpd.getMatches().hasNext()) {
            System.out.println(arguments.getRenderer().render(cpd.getMatches()));
            CPDCommandLineInterface.setStatusCodeOrExit(4);
        }
    }

    private static void addSourcesFilesToCPD(List<String> files, CPD cpd, boolean recursive) {
        try {
            for (String file : files) {
                if (recursive) {
                    cpd.addRecursively(file);
                    continue;
                }
                cpd.addAllInDirectory(file);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void addSourceURIToCPD(String uri, CPD cpd) {
        try {
            LOGGER.fine(String.format("Attempting DBURI=%s", uri));
            DBURI dburi = new DBURI(uri);
            LOGGER.fine(String.format("Initialised DBURI=%s", dburi));
            LOGGER.fine(String.format("Adding DBURI=%s with DBType=%s", dburi.toString(), dburi.getDbType().toString()));
            cpd.add(dburi);
        }
        catch (IOException e) {
            throw new IllegalStateException("uri=" + uri, e);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("uri=" + uri, ex);
        }
        catch (Exception ex) {
            throw new IllegalStateException("uri=" + uri, ex);
        }
    }

    public static String buildUsageText() {
        String helpText = "Usage:";
        helpText = helpText + " java net.sourceforge.pmd.cpd.CPD --minimum-tokens xxx --files xxx [--language xxx] [--encoding xxx] [--format (xml|text|csv|vs)] [--skip-duplicate-files] [--non-recursive]\n";
        helpText = helpText + "i.e: \n";
        helpText = helpText + " java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files c:\\jdk14\\src\\java \n";
        helpText = helpText + "or: \n";
        helpText = helpText + " java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files /path/to/c/code --language c \n";
        helpText = helpText + "or: \n";
        helpText = helpText + " java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --encoding UTF-16LE --files /path/to/java/code --format xml\n";
        return helpText;
    }
}

