/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.util.FileFinder;

public class CPDConfiguration
extends AbstractConfiguration {
    public static final String DEFAULT_LANGUAGE = "java";
    public static final String DEFAULT_RENDERER = "text";
    @Parameter(names={"--language"}, description="Sources code language. Default value is java", required=false, converter=LanguageConverter.class)
    private Language language;
    @Parameter(names={"--minimum-tokens"}, description="The minimum token length which should be reported as a duplicate.", required=true)
    private int minimumTileSize;
    @Parameter(names={"--skip-duplicate-files"}, description="Ignore multiple copies of files of the same name and length in comparison", required=false)
    private boolean skipDuplicates;
    @Parameter(names={"--format"}, description="Report format. Default value is text", required=false)
    private String rendererName;
    private Renderer renderer;
    @Parameter(names={"--encoding"}, description="Characterset to use when processing files", required=false)
    private String encoding;
    @Parameter(names={"--ignore-literals"}, description="Ignore number values and string contents when comparing text", required=false)
    private boolean ignoreLiterals;
    @Parameter(names={"--ignore-identifiers"}, description="Ignore constant and variable names when comparing text", required=false)
    private boolean ignoreIdentifiers;
    @Parameter(names={"--ignore-annotations"}, description="Ignore language annotations when comparing text", required=false)
    private boolean ignoreAnnotations;
    @Parameter(names={"--skip-lexical-errors"}, description="Skip files which can't be tokenized due to invalid characters instead of aborting CPD", required=false)
    private boolean skipLexicalErrors = false;
    @Parameter(names={"--files"}, variableArity=true, description="List of files and directories to process", required=false)
    private List<String> files;
    @Parameter(names={"--exclude"}, variableArity=true, description="Files to be excluded from CPD check", required=false)
    private List<String> excludes;
    @Parameter(names={"--non-recursive"}, description="Don't scan subdirectiories", required=false)
    private boolean nonRecursive;
    @Parameter(names={"--uri"}, description="URI to process", required=false)
    private String uri;
    @Parameter(names={"--help", "-h"}, description="Print help text", required=false, help=true)
    private boolean help;

    public CPDConfiguration() {
    }

    @Deprecated
    public CPDConfiguration(int minimumTileSize, Language language, String encoding) {
        this.setMinimumTileSize(minimumTileSize);
        this.setLanguage(language);
        this.setEncoding(encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public SourceCode sourceCodeFor(File file) {
        return new SourceCode(new SourceCode.FileCodeLoader(file, this.getSourceEncoding()));
    }

    public SourceCode sourceCodeFor(Reader reader, String sourceCodeName) {
        return new SourceCode(new SourceCode.ReaderCodeLoader(reader, sourceCodeName));
    }

    public void postContruct() {
        if (this.getEncoding() != null) {
            super.setSourceEncoding(this.getEncoding());
            if (!this.getEncoding().equals(System.getProperty("file.encoding"))) {
                System.setProperty("file.encoding", this.getEncoding());
            }
        }
        if (this.getLanguage() == null) {
            this.setLanguage(CPDConfiguration.getLanguageFromString(DEFAULT_LANGUAGE));
        }
        if (this.getRendererName() == null) {
            this.setRendererName(DEFAULT_RENDERER);
        }
        if (this.getRenderer() == null) {
            this.setRenderer(CPDConfiguration.getRendererFromString(this.getRendererName()));
        }
    }

    public static Renderer getRendererFromString(String name) {
        if (name.equalsIgnoreCase(DEFAULT_RENDERER) || name.equals("")) {
            return new SimpleRenderer();
        }
        if ("xml".equals(name)) {
            return new XMLRenderer();
        }
        if ("csv".equals(name)) {
            return new CSVRenderer();
        }
        if ("vs".equals(name)) {
            return new VSRenderer();
        }
        try {
            return (Renderer)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            System.out.println("Can't find class '" + name + "', defaulting to SimpleRenderer.");
            return new SimpleRenderer();
        }
    }

    public static Language getLanguageFromString(String languageString) {
        return new LanguageFactory().createLanguage(languageString);
    }

    public static void setSystemProperties(CPDConfiguration configuration) {
        Properties properties = System.getProperties();
        if (configuration.isIgnoreLiterals()) {
            properties.setProperty("ignore_literals", "true");
        } else {
            properties.remove("ignore_literals");
        }
        if (configuration.isIgnoreIdentifiers()) {
            properties.setProperty("ignore_identifiers", "true");
        } else {
            properties.remove("ignore_identifiers");
        }
        if (configuration.isIgnoreAnnotations()) {
            properties.setProperty("ignore_annotations", "true");
        } else {
            properties.remove("ignore_annotations");
        }
        System.setProperties(properties);
        configuration.getLanguage().setProperties(properties);
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public int getMinimumTileSize() {
        return this.minimumTileSize;
    }

    public void setMinimumTileSize(int minimumTileSize) {
        this.minimumTileSize = minimumTileSize;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public String getRendererName() {
        return this.rendererName;
    }

    public void setRendererName(String rendererName) {
        this.rendererName = rendererName;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Tokenizer tokenizer() {
        if (this.language == null) {
            throw new IllegalStateException("Language is null.");
        }
        return this.language.getTokenizer();
    }

    public FilenameFilter filenameFilter() {
        if (this.language == null) {
            throw new IllegalStateException("Language is null.");
        }
        final FilenameFilter languageFilter = this.language.getFileFilter();
        final HashSet<String> exclusions = new HashSet<String>();
        if (this.excludes != null) {
            FileFinder finder = new FileFinder();
            for (String excludedFile : this.excludes) {
                File exFile = new File(excludedFile);
                if (exFile.isDirectory()) {
                    List<File> files = finder.findFilesFrom(excludedFile, languageFilter, true);
                    for (File f : files) {
                        exclusions.add(f.getAbsolutePath());
                    }
                    continue;
                }
                exclusions.add(exFile.getAbsolutePath());
            }
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                if (exclusions.contains(f.getAbsolutePath())) {
                    System.err.println("Excluding " + f.getAbsolutePath());
                    return false;
                }
                return languageFilter.accept(dir, name);
            }
        };
        return filter;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public boolean isIgnoreLiterals() {
        return this.ignoreLiterals;
    }

    public void setIgnoreLiterals(boolean ignoreLiterals) {
        this.ignoreLiterals = ignoreLiterals;
    }

    public boolean isIgnoreIdentifiers() {
        return this.ignoreIdentifiers;
    }

    public void setIgnoreIdentifiers(boolean ignoreIdentifiers) {
        this.ignoreIdentifiers = ignoreIdentifiers;
    }

    public boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public boolean isSkipLexicalErrors() {
        return this.skipLexicalErrors;
    }

    public void setSkipLexicalErrors(boolean skipLexicalErrors) {
        this.skipLexicalErrors = skipLexicalErrors;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean nonRecursive) {
        this.nonRecursive = nonRecursive;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static class LanguageConverter
    implements IStringConverter<Language> {
        public Language convert(String languageString) {
            if (languageString == null || "".equals(languageString)) {
                languageString = CPDConfiguration.DEFAULT_LANGUAGE;
            }
            return new LanguageFactory().createLanguage(languageString);
        }
    }
}

