/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd.graph;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.dcd.asm.PrintVisitor;
import net.sourceforge.pmd.dcd.asm.TypeSignatureVisitor;
import net.sourceforge.pmd.dcd.graph.MemberNode;
import net.sourceforge.pmd.dcd.graph.UsageGraph;
import net.sourceforge.pmd.util.filter.Filter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class UsageGraphBuilder {
    private static final boolean TRACE = false;
    private static final boolean INDEX = true;
    protected final UsageGraph usageGraph;
    protected final Filter<String> classFilter;

    public UsageGraphBuilder(Filter<String> classFilter) {
        this.classFilter = classFilter;
        this.usageGraph = new UsageGraph(classFilter);
    }

    public void index(String name) {
        try {
            String className = UsageGraphBuilder.getClassName(name);
            String classResourceName = UsageGraphBuilder.getResourceName(name);
            if (this.classFilter.filter(className) && !this.usageGraph.isClass(className)) {
                this.usageGraph.defineClass(className);
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(classResourceName + ".class");
                ClassReader classReader = new ClassReader(inputStream);
                classReader.accept(this.getNewClassVisitor(), 0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("For " + name + ": " + e.getMessage(), e);
        }
    }

    public UsageGraph getUsageGraph() {
        return this.usageGraph;
    }

    private ClassVisitor getNewClassVisitor() {
        return new MyClassVisitor();
    }

    protected MethodVisitor getNewMethodVisitor(PrintVisitor parent, MemberNode usingMemberNode) {
        return new MyMethodVisitor(parent, usingMemberNode);
    }

    private static String getResourceName(String name) {
        return name.replace('.', '/');
    }

    static String getClassName(String name) {
        return name.replace('/', '.');
    }

    private static List<Integer> asList(int[] array) {
        ArrayList<Integer> list = null;
        if (array != null) {
            list = new ArrayList<Integer>(array.length);
            for (int i : array) {
                list.add(i);
            }
        }
        return list;
    }

    private static List<Object> asList(Object[] array) {
        return array != null ? Arrays.asList(array) : null;
    }

    protected class MyMethodVisitor
    extends MethodVisitor {
        private final PrintVisitor p;
        private final MemberNode usingMemberNode;

        protected void println(String s) {
            this.p.println(s);
        }

        protected void printlnIndent(String s) {
            this.p.printlnIndent(s);
        }

        public MyMethodVisitor(PrintVisitor parent, MemberNode usingMemberNode) {
            super(262144);
            this.p = parent;
            this.usingMemberNode = usingMemberNode;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitCode() {
        }

        public void visitEnd() {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String className = UsageGraphBuilder.getClassName(owner);
            UsageGraphBuilder.this.usageGraph.usageField(className, name, desc, this.usingMemberNode);
        }

        public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String className = UsageGraphBuilder.getClassName(owner);
            UsageGraphBuilder.this.usageGraph.usageMethod(className, name, desc, this.usingMemberNode);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitVarInsn(int opcode, int var) {
        }
    }

    class MyClassVisitor
    extends ClassVisitor {
        private final PrintVisitor p;
        private String className;

        protected void println(String s) {
            this.p.println(s);
        }

        protected void printlnIndent(String s) {
            this.p.printlnIndent(s);
        }

        public MyClassVisitor() {
            super(262144);
            this.p = new PrintVisitor();
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = UsageGraphBuilder.getClassName(name);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            SignatureReader signatureReader = new SignatureReader(desc);
            TypeSignatureVisitor visitor = new TypeSignatureVisitor(this.p);
            signatureReader.acceptType((SignatureVisitor)visitor);
            UsageGraphBuilder.this.usageGraph.defineField(this.className, name, desc);
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            UsageGraphBuilder.this.index(name);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MemberNode memberNode = null;
            memberNode = UsageGraphBuilder.this.usageGraph.defineMethod(this.className, name, desc);
            return UsageGraphBuilder.this.getNewMethodVisitor(this.p, memberNode);
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }
    }
}

