/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;

public class AttributeAxisIterator
implements Iterator<Attribute> {
    private Attribute currObj;
    private MethodWrapper[] methodWrappers;
    private int position;
    private Node node;
    private static Map<Class<?>, MethodWrapper[]> methodCache = Collections.synchronizedMap(new HashMap());

    public AttributeAxisIterator(Node contextNode) {
        this.node = contextNode;
        if (!methodCache.containsKey(contextNode.getClass())) {
            Method[] preFilter = contextNode.getClass().getMethods();
            ArrayList<MethodWrapper> postFilter = new ArrayList<MethodWrapper>();
            for (Method element : preFilter) {
                if (!this.isAttributeAccessor(element)) continue;
                postFilter.add(new MethodWrapper(element));
            }
            methodCache.put(contextNode.getClass(), postFilter.toArray(new MethodWrapper[postFilter.size()]));
        }
        this.methodWrappers = methodCache.get(contextNode.getClass());
        this.position = 0;
        this.currObj = this.getNextAttribute();
    }

    @Override
    public Attribute next() {
        if (this.currObj == null) {
            throw new IndexOutOfBoundsException();
        }
        Attribute ret = this.currObj;
        this.currObj = this.getNextAttribute();
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.currObj != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Attribute getNextAttribute() {
        if (this.methodWrappers == null || this.position == this.methodWrappers.length) {
            return null;
        }
        MethodWrapper m = this.methodWrappers[this.position++];
        return new Attribute(this.node, m.name, m.method);
    }

    protected boolean isAttributeAccessor(Method method) {
        String methodName = method.getName();
        boolean deprecated = method.getAnnotation(Deprecated.class) != null;
        return !deprecated && (Integer.TYPE == method.getReturnType() || Boolean.TYPE == method.getReturnType() || Double.TYPE == method.getReturnType() || String.class == method.getReturnType()) && method.getParameterTypes().length == 0 && Void.TYPE != method.getReturnType() && !methodName.startsWith("jjt") && !methodName.equals("toString") && !methodName.equals("getScope") && !methodName.equals("getClass") && !methodName.equals("getTypeNameNode") && !methodName.equals("getImportedNameNode") && !methodName.equals("hashCode");
    }

    private static class MethodWrapper {
        public Method method;
        public String name;

        public MethodWrapper(Method m) {
            this.method = m;
            this.name = this.truncateMethodName(m.getName());
        }

        private String truncateMethodName(String n) {
            if (n.startsWith("get")) {
                return n.substring("get".length());
            }
            if (n.startsWith("is")) {
                return n.substring("is".length());
            }
            if (n.startsWith("has")) {
                return n.substring("has".length());
            }
            if (n.startsWith("uses")) {
                return n.substring("uses".length());
            }
            return n;
        }
    }
}

