/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.dfa.NodeType;
import net.sourceforge.pmd.lang.dfa.StackObject;

public class SequenceChecker {
    private static final Logger LOGGER = Logger.getLogger(SequenceChecker.class.getName());
    private static Status root = new Status(-1);
    private Status aktStatus = root;
    private List<StackObject> bracesList;
    private int firstIndex = -1;
    private int lastIndex = -1;

    public SequenceChecker(List<StackObject> bracesList) {
        this.bracesList = bracesList;
    }

    public boolean run() {
        LOGGER.entering(this.getClass().getCanonicalName(), "run");
        this.aktStatus = root;
        this.firstIndex = 0;
        this.lastIndex = 0;
        boolean lookAhead = false;
        int maximumIterations = this.bracesList.size() * this.bracesList.size();
        int l = 0;
        for (int i = 0; i < this.bracesList.size(); ++i) {
            StackObject so = this.bracesList.get(i);
            LOGGER.finest("Processing bracesList(l,i)=(" + l + "," + i + ") of Type " + NodeType.stringFromType(so.getType()) + " with State (aktStatus) = " + this.aktStatus);
            LOGGER.finest("DataFlowNode @ line " + so.getDataFlowNode().getLine() + " and index=" + so.getDataFlowNode().getIndex());
            this.aktStatus = this.aktStatus.step(so.getType());
            LOGGER.finest("Transition aktStatus=" + this.aktStatus);
            if (this.aktStatus == null) {
                if (lookAhead) {
                    this.lastIndex = i - 1;
                    LOGGER.finer("aktStatus is NULL (lookAhead): Invalid transition");
                    LOGGER.exiting(this.getClass().getCanonicalName(), "run", false);
                    return false;
                }
                if (l > maximumIterations) {
                    LOGGER.severe("aktStatus is NULL: maximum Iterations exceeded, abort " + i);
                    LOGGER.exiting(this.getClass().getCanonicalName(), "run", false);
                    return false;
                }
                this.aktStatus = root;
                this.firstIndex = i--;
                LOGGER.finest("aktStatus is NULL: Restarting search continue i==" + i + ", firstIndex=" + this.firstIndex);
            } else {
                if (this.aktStatus.isLastStep() && !this.aktStatus.hasMoreSteps()) {
                    this.lastIndex = i;
                    LOGGER.finest("aktStatus is NOT NULL: lastStep reached and no moreSteps - firstIndex=" + this.firstIndex + ", lastIndex=" + this.lastIndex);
                    LOGGER.exiting(this.getClass().getCanonicalName(), "run", false);
                    return false;
                }
                if (this.aktStatus.isLastStep() && this.aktStatus.hasMoreSteps()) {
                    lookAhead = true;
                    this.lastIndex = i;
                    LOGGER.finest("aktStatus is NOT NULL: set lookAhead on");
                }
            }
            ++l;
        }
        LOGGER.finer("Completed search: firstIndex=" + this.firstIndex + ", lastIndex=" + this.lastIndex);
        LOGGER.exiting(this.getClass().getCanonicalName(), "run", this.firstIndex == this.lastIndex);
        return this.firstIndex == this.lastIndex;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    static {
        Status ifNode = new Status(1);
        Status ifSt = new Status(2);
        Status ifStWithoutElse = new Status(3, true);
        Status elseSt = new Status(4, true);
        Status whileNode = new Status(10);
        Status whileSt = new Status(11, true);
        Status switchNode = new Status(20);
        Status caseSt = new Status(21);
        Status switchDefault = new Status(22);
        Status switchEnd = new Status(23, true);
        Status forInit = new Status(30);
        Status forExpr = new Status(31);
        Status forUpdate = new Status(32);
        Status forSt = new Status(33);
        Status forEnd = new Status(34, true);
        Status doSt = new Status(40);
        Status doExpr = new Status(41, true);
        Status labelNode = new Status(60);
        Status labelEnd = new Status(61, true);
        root.addStep(ifNode);
        root.addStep(whileNode);
        root.addStep(switchNode);
        root.addStep(forInit);
        root.addStep(forExpr);
        root.addStep(forUpdate);
        root.addStep(forSt);
        root.addStep(doSt);
        root.addStep(labelNode);
        ifNode.addStep(ifSt);
        ifNode.addStep(ifStWithoutElse);
        ifSt.addStep(elseSt);
        ifStWithoutElse.addStep(root);
        elseSt.addStep(root);
        labelNode.addStep(labelEnd);
        labelEnd.addStep(root);
        whileNode.addStep(whileSt);
        whileSt.addStep(root);
        switchNode.addStep(caseSt);
        switchNode.addStep(switchDefault);
        switchNode.addStep(switchEnd);
        caseSt.addStep(caseSt);
        caseSt.addStep(switchDefault);
        caseSt.addStep(switchEnd);
        switchDefault.addStep(switchEnd);
        switchDefault.addStep(caseSt);
        switchEnd.addStep(root);
        forInit.addStep(forExpr);
        forInit.addStep(forUpdate);
        forInit.addStep(forSt);
        forExpr.addStep(forUpdate);
        forExpr.addStep(forSt);
        forUpdate.addStep(forSt);
        forSt.addStep(forEnd);
        forEnd.addStep(root);
        doSt.addStep(doExpr);
        doExpr.addStep(root);
    }

    private static class Status {
        public static final int ROOT = -1;
        private List<Status> nextSteps = new ArrayList<Status>();
        private int type;
        private boolean lastStep;

        public Status(int type) {
            this(type, false);
        }

        public Status(int type, boolean lastStep) {
            this.type = type;
            this.lastStep = lastStep;
        }

        public void addStep(Status type) {
            this.nextSteps.add(type);
        }

        public Status step(int type) {
            for (int i = 0; i < this.nextSteps.size(); ++i) {
                if (type != this.nextSteps.get((int)i).type) continue;
                return this.nextSteps.get(i);
            }
            return null;
        }

        public boolean isLastStep() {
            return this.lastStep;
        }

        public boolean hasMoreSteps() {
            return this.nextSteps.size() > 1;
        }

        public String toString() {
            return "NodeType=" + NodeType.stringFromType(this.type) + "(" + this.type + "), lastStep=" + this.lastStep;
        }
    }
}

