/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ecmascript.EcmascriptParserOptions;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptTreeBuilder;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ErrorCollector;
import org.mozilla.javascript.ast.ParseProblem;

public class EcmascriptParser {
    protected final EcmascriptParserOptions parserOptions;
    private Map<Integer, String> suppressMap;
    private String suppressMarker = "NOPMD";

    public EcmascriptParser(EcmascriptParserOptions parserOptions) {
        this.parserOptions = parserOptions;
        if (parserOptions.getSuppressMarker() != null) {
            this.suppressMarker = parserOptions.getSuppressMarker();
        }
    }

    protected AstRoot parseEcmascript(String sourceCode, List<ParseProblem> parseProblems) throws ParseException {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setRecordingComments(this.parserOptions.isRecordingComments());
        compilerEnvirons.setRecordingLocalJsDocComments(this.parserOptions.isRecordingLocalJsDocComments());
        compilerEnvirons.setLanguageVersion(this.parserOptions.getRhinoLanguageVersion().getVersion());
        compilerEnvirons.setIdeMode(true);
        compilerEnvirons.setWarnTrailingComma(true);
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        ErrorCollector errorCollector = new ErrorCollector();
        Parser parser = new Parser(compilerEnvirons, (ErrorReporter)errorCollector);
        String sourceURI = "unknown";
        boolean beginLineno = true;
        AstRoot astRoot = parser.parse(sourceCode, "unknown", 1);
        parseProblems.addAll(errorCollector.getErrors());
        return astRoot;
    }

    public EcmascriptNode<AstRoot> parse(Reader reader) {
        try {
            ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
            String sourceCode = IOUtils.toString((Reader)reader);
            AstRoot astRoot = this.parseEcmascript(sourceCode, parseProblems);
            EcmascriptTreeBuilder treeBuilder = new EcmascriptTreeBuilder(sourceCode, parseProblems);
            EcmascriptNode<AstRoot> tree = treeBuilder.build(astRoot);
            this.suppressMap = new HashMap<Integer, String>();
            if (astRoot.getComments() != null) {
                for (Comment comment : astRoot.getComments()) {
                    int nopmd = comment.getValue().indexOf(this.suppressMarker);
                    if (nopmd <= -1) continue;
                    String suppression = comment.getValue().substring(nopmd + this.suppressMarker.length());
                    EcmascriptNode<Comment> node = treeBuilder.build(comment);
                    this.suppressMap.put(node.getBeginLine(), suppression);
                }
            }
            return tree;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public Map<Integer, String> getSuppressMap() {
        return this.suppressMap;
    }
}

