/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTLiteral
extends AbstractJavaTypeNode {
    private boolean isInt;
    private boolean isFloat;
    private boolean isChar;
    private boolean isString;
    private static final Pattern SINGLE_CHAR_ESCAPE_PATTERN = Pattern.compile("^\"\\\\(([ntbrf\\\\'\\\"])|([0-7][0-7]?)|([0-3][0-7][0-7]))\"");

    public ASTLiteral(int id) {
        super(id);
    }

    public ASTLiteral(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void setIntLiteral() {
        this.isInt = true;
    }

    public boolean isIntLiteral() {
        return this.isInt;
    }

    public void setFloatLiteral() {
        this.isFloat = true;
    }

    public boolean isFloatLiteral() {
        return this.isFloat;
    }

    public void setCharLiteral() {
        this.isChar = true;
    }

    public boolean isCharLiteral() {
        return this.isChar;
    }

    public void setStringLiteral() {
        this.isString = true;
    }

    public boolean isStringLiteral() {
        return this.isString;
    }

    public boolean isSingleCharacterStringLiteral() {
        if (this.isString) {
            String image = this.getImage();
            int length = image.length();
            if (length == 3) {
                return true;
            }
            if (image.charAt(1) == '\\') {
                return SINGLE_CHAR_ESCAPE_PATTERN.matcher(image).matches();
            }
        }
        return false;
    }
}

