/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTRelationalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public abstract class AbstractInefficientZeroCheck
extends AbstractJavaRule {
    public abstract boolean appliesToClassName(String var1);

    public abstract boolean isTargetMethod(JavaNameOccurrence var1);

    public List<String> getComparisonTargets() {
        return Arrays.asList("0");
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        Node nameNode = node.getTypeNameNode();
        if (nameNode == null || nameNode instanceof ASTPrimitiveType || !this.appliesToClassName(node.getNameDeclaration().getTypeImage())) {
            return data;
        }
        List<NameOccurrence> declars = node.getUsages();
        for (NameOccurrence occ : declars) {
            JavaNameOccurrence jocc = (JavaNameOccurrence)occ;
            if (!this.isTargetMethod(jocc)) continue;
            Node expr = jocc.getLocation().jjtGetParent().jjtGetParent().jjtGetParent();
            this.checkNodeAndReport(data, jocc.getLocation(), expr);
        }
        return data;
    }

    protected void checkNodeAndReport(Object data, Node location, Node expr) {
        if ((expr instanceof ASTEqualityExpression || expr instanceof ASTRelationalExpression && (">".equals(expr.getImage()) || "<".equals(expr.getImage()))) && this.isCompare(expr)) {
            this.addViolation(data, location);
        }
    }

    private boolean isCompare(Node equality) {
        return this.checkComparison(equality, 0) || this.checkComparison(equality, 1);
    }

    private boolean checkComparison(Node equality, int i) {
        Node target = equality.jjtGetChild(i).jjtGetChild(0);
        if (target.jjtGetNumChildren() == 0) {
            return false;
        }
        return (target = target.jjtGetChild(0)) instanceof ASTLiteral && this.getComparisonTargets().indexOf(target.getImage()) > -1;
    }
}

