/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.CanSuppressWarnings;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.rule.ParametricRuleViolation;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class JavaRuleViolation
extends ParametricRuleViolation<JavaNode> {
    public JavaRuleViolation(Rule rule, RuleContext ctx, JavaNode node, String message, int beginLine, int endLine) {
        this(rule, ctx, node, message);
        this.setLines(beginLine, endLine);
    }

    public JavaRuleViolation(Rule rule, RuleContext ctx, JavaNode node, String message) {
        super(rule, ctx, node, message);
        if (node != null) {
            Scope scope = node.getScope();
            SourceFileScope sourceFileScope = scope.getEnclosingScope(SourceFileScope.class);
            this.packageName = sourceFileScope.getPackageName() == null ? "" : sourceFileScope.getPackageName();
            this.setClassNameFrom(node);
            if (node.getFirstParentOfType(ASTMethodDeclaration.class) != null) {
                this.methodName = scope.getEnclosingScope(MethodScope.class).getName();
            }
            this.setVariableNameIfExists(node);
            if (!this.suppressed) {
                this.suppressed = JavaRuleViolation.isSupressed(node, this.getRule());
            }
        }
    }

    public static boolean isSupressed(Node node, Rule rule) {
        boolean result = JavaRuleViolation.suppresses(node, rule);
        if (!result && node instanceof ASTCompilationUnit) {
            for (int i = 0; !result && i < node.jjtGetNumChildren(); ++i) {
                result = JavaRuleViolation.suppresses(node.jjtGetChild(i), rule);
            }
        }
        if (!result) {
            for (Node parent = node.jjtGetParent(); !result && parent != null; parent = parent.jjtGetParent()) {
                result = JavaRuleViolation.suppresses(parent, rule);
            }
        }
        return result;
    }

    private void setClassNameFrom(JavaNode node) {
        String qualifiedName = null;
        for (ASTClassOrInterfaceDeclaration parent : node.getParentsOfType(ASTClassOrInterfaceDeclaration.class)) {
            String clsName = parent.getScope().getEnclosingScope(ClassScope.class).getClassName();
            if (qualifiedName == null) {
                qualifiedName = clsName;
                continue;
            }
            qualifiedName = clsName + '$' + qualifiedName;
        }
        if (qualifiedName != null) {
            this.className = qualifiedName;
        }
    }

    private static boolean suppresses(Node node, Rule rule) {
        return node instanceof CanSuppressWarnings && ((CanSuppressWarnings)((Object)node)).hasSuppressWarningsAnnotationFor(rule);
    }

    private void setVariableNameIfExists(Node node) {
        if (node instanceof ASTFieldDeclaration) {
            this.variableName = ((ASTFieldDeclaration)node).getVariableName();
        } else if (node instanceof ASTLocalVariableDeclaration) {
            this.variableName = ((ASTLocalVariableDeclaration)node).getVariableName();
        } else if (node instanceof ASTVariableDeclarator) {
            this.variableName = node.jjtGetChild(0).getImage();
        } else if (node instanceof ASTVariableDeclaratorId) {
            this.variableName = node.getImage();
        } else if (node instanceof ASTFormalParameter) {
            this.setVariableNameIfExists(node.getFirstChildOfType(ASTVariableDeclaratorId.class));
        } else {
            this.variableName = "";
        }
    }
}

