/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.coupling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;
import net.sourceforge.pmd.util.CollectionUtil;

public class LoosePackageCouplingRule
extends AbstractJavaRule {
    public static final StringMultiProperty PACKAGES_DESCRIPTOR = new StringMultiProperty("packages", "Restricted packages", new String[0], 1.0f, ',');
    public static final StringMultiProperty CLASSES_DESCRIPTOR = new StringMultiProperty("classes", "Allowed classes", new String[0], 2.0f, ',');
    private String thisPackage;
    private List<String> restrictedPackages;

    public LoosePackageCouplingRule() {
        this.definePropertyDescriptor(PACKAGES_DESCRIPTOR);
        this.definePropertyDescriptor(CLASSES_DESCRIPTOR);
        this.addRuleChainVisit(ASTCompilationUnit.class);
        this.addRuleChainVisit(ASTPackageDeclaration.class);
        this.addRuleChainVisit(ASTImportDeclaration.class);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.thisPackage = "";
        this.restrictedPackages = new ArrayList<Object>(Arrays.asList((Object[])super.getProperty(PACKAGES_DESCRIPTOR)));
        Collections.sort(this.restrictedPackages, Collections.reverseOrder());
        return data;
    }

    @Override
    public Object visit(ASTPackageDeclaration node, Object data) {
        this.thisPackage = node.getPackageNameImage();
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        String importPackage = node.getPackageName();
        for (String pkg : this.getRestrictedPackages()) {
            if (!this.isContainingPackage(pkg, importPackage)) continue;
            if (pkg.equals(this.thisPackage) || this.isContainingPackage(pkg, this.thisPackage)) break;
            if (node.isImportOnDemand()) {
                this.addViolation(data, (Node)node, new Object[]{node.getImportedName(), pkg});
                break;
            }
            if (this.isAllowedClass(node)) continue;
            this.addViolation(data, (Node)node, new Object[]{node.getImportedName(), pkg});
            break;
        }
        return data;
    }

    protected List<String> getRestrictedPackages() {
        return this.restrictedPackages;
    }

    protected boolean isContainingPackage(String pkg1, String pkg2) {
        return pkg1.equals(pkg2) || pkg1.length() < pkg2.length() && pkg2.startsWith(pkg1) && pkg2.charAt(pkg1.length()) == '.';
    }

    protected boolean isAllowedClass(ASTImportDeclaration node) {
        String importedName = node.getImportedName();
        for (String clazz : this.getProperty(CLASSES_DESCRIPTOR)) {
            if (!importedName.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean checksNothing() {
        return CollectionUtil.isEmpty(this.getProperty(PACKAGES_DESCRIPTOR)) && CollectionUtil.isEmpty(this.getProperty(CLASSES_DESCRIPTOR));
    }

    @Override
    public String dysfunctionReason() {
        return this.checksNothing() ? "No packages or classes specified" : null;
    }
}

