/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractJavaRule {
    private int depth;
    private int depthLimit;
    private static final IntegerProperty PROBLEM_DEPTH_DESCRIPTOR = new IntegerProperty("problemDepth", "The if statement depth reporting threshold", 1, 25, 3, 1.0f);

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor(PROBLEM_DEPTH_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.depth = 0;
        this.depthLimit = this.getProperty(PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (!node.hasElse()) {
            ++this.depth;
        }
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, node);
        }
        --this.depth;
        return data;
    }
}

