/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.naming;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;
import net.sourceforge.pmd.util.CollectionUtil;

public class VariableNamingConventionsRule
extends AbstractJavaRule {
    private boolean checkMembers;
    private boolean checkLocals;
    private boolean checkParameters;
    private String[] staticPrefixes;
    private String[] staticSuffixes;
    private String[] memberPrefixes;
    private String[] memberSuffixes;
    private String[] localPrefixes;
    private String[] localSuffixes;
    private String[] parameterPrefixes;
    private String[] parameterSuffixes;
    private static final BooleanProperty CHECK_MEMBERS_DESCRIPTOR = new BooleanProperty("checkMembers", "Check member variables", true, 1.0f);
    private static final BooleanProperty CHECK_LOCALS_DESCRIPTOR = new BooleanProperty("checkLocals", "Check local variables", true, 2.0f);
    private static final BooleanProperty CHECK_PARAMETERS_DESCRIPTOR = new BooleanProperty("checkParameters", "Check constructor and method parameter variables", true, 3.0f);
    private static final StringMultiProperty STATIC_PREFIXES_DESCRIPTOR = new StringMultiProperty("staticPrefix", "Static variable prefixes", new String[]{""}, 4.0f, ',');
    private static final StringMultiProperty STATIC_SUFFIXES_DESCRIPTOR = new StringMultiProperty("staticSuffix", "Static variable suffixes", new String[]{""}, 5.0f, ',');
    private static final StringMultiProperty MEMBER_PREFIXES_DESCRIPTOR = new StringMultiProperty("memberPrefix", "Member variable prefixes", new String[]{""}, 6.0f, ',');
    private static final StringMultiProperty MEMBER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("memberSuffix", "Member variable suffixes", new String[]{""}, 7.0f, ',');
    private static final StringMultiProperty LOCAL_PREFIXES_DESCRIPTOR = new StringMultiProperty("localPrefix", "Local variable prefixes", new String[]{""}, 8.0f, ',');
    private static final StringMultiProperty LOCAL_SUFFIXES_DESCRIPTOR = new StringMultiProperty("localSuffix", "Local variable suffixes", new String[]{""}, 9.0f, ',');
    private static final StringMultiProperty PARAMETER_PREFIXES_DESCRIPTOR = new StringMultiProperty("parameterPrefix", "Method parameter variable prefixes", new String[]{""}, 10.0f, ',');
    private static final StringMultiProperty PARAMETER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("parameterSuffix", "Method parameter variable suffixes", new String[]{""}, 11.0f, ',');

    public VariableNamingConventionsRule() {
        this.definePropertyDescriptor(CHECK_MEMBERS_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_LOCALS_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_PARAMETERS_DESCRIPTOR);
        this.definePropertyDescriptor(STATIC_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(STATIC_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(MEMBER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(MEMBER_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(LOCAL_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(LOCAL_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(PARAMETER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor(PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.checkMembers = this.getProperty(CHECK_MEMBERS_DESCRIPTOR);
        this.checkLocals = this.getProperty(CHECK_LOCALS_DESCRIPTOR);
        this.checkParameters = this.getProperty(CHECK_PARAMETERS_DESCRIPTOR);
        this.staticPrefixes = this.getProperty(STATIC_PREFIXES_DESCRIPTOR);
        this.staticSuffixes = this.getProperty(STATIC_SUFFIXES_DESCRIPTOR);
        this.memberPrefixes = this.getProperty(MEMBER_PREFIXES_DESCRIPTOR);
        this.memberSuffixes = this.getProperty(MEMBER_SUFFIXES_DESCRIPTOR);
        this.localPrefixes = this.getProperty(LOCAL_PREFIXES_DESCRIPTOR);
        this.localSuffixes = this.getProperty(LOCAL_SUFFIXES_DESCRIPTOR);
        this.parameterPrefixes = this.getProperty(PARAMETER_PREFIXES_DESCRIPTOR);
        this.parameterSuffixes = this.getProperty(PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (!this.checkMembers) {
            return data;
        }
        boolean isStatic = node.isStatic();
        boolean isFinal = node.isFinal();
        if (node.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node.jjtGetParent().jjtGetParent().jjtGetParent()).isInterface()) {
            isStatic = true;
            isFinal = true;
        }
        return this.checkVariableDeclarators(node.isStatic() ? this.staticPrefixes : this.memberPrefixes, isStatic ? this.staticSuffixes : this.memberSuffixes, node, isStatic, isFinal, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        if (!this.checkLocals) {
            return data;
        }
        return this.checkVariableDeclarators(this.localPrefixes, this.localSuffixes, node, false, node.isFinal(), data);
    }

    @Override
    public Object visit(ASTFormalParameters node, Object data) {
        if (!this.checkParameters) {
            return data;
        }
        for (ASTFormalParameter formalParameter : node.findChildrenOfType(ASTFormalParameter.class)) {
            for (ASTVariableDeclaratorId variableDeclaratorId : formalParameter.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                this.checkVariableDeclaratorId(this.parameterPrefixes, this.parameterSuffixes, node, false, formalParameter.isFinal(), variableDeclaratorId, data);
            }
        }
        return data;
    }

    private Object checkVariableDeclarators(String[] prefixes, String[] suffixes, Node root, boolean isStatic, boolean isFinal, Object data) {
        for (ASTVariableDeclarator variableDeclarator : root.findChildrenOfType(ASTVariableDeclarator.class)) {
            for (ASTVariableDeclaratorId variableDeclaratorId : variableDeclarator.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                this.checkVariableDeclaratorId(prefixes, suffixes, root, isStatic, isFinal, variableDeclaratorId, data);
            }
        }
        return data;
    }

    private Object checkVariableDeclaratorId(String[] prefixes, String[] suffixes, Node root, boolean isStatic, boolean isFinal, ASTVariableDeclaratorId variableDeclaratorId, Object data) {
        String varName = variableDeclaratorId.getImage();
        if (varName.equals("serialVersionUID")) {
            return data;
        }
        if (isStatic && isFinal) {
            if (!varName.equals(varName.toUpperCase())) {
                this.addViolationWithMessage(data, variableDeclaratorId, "Variables that are final and static should be all capitals, ''{0}'' is not all capitals.", new Object[]{varName});
            }
            return data;
        }
        if (!isFinal) {
            String normalizedVarName = this.normalizeVariableName(varName, prefixes, suffixes);
            if (normalizedVarName.indexOf(95) >= 0) {
                this.addViolationWithMessage(data, variableDeclaratorId, "Only variables that are final should contain underscores (except for underscores in standard prefix/suffix), ''{0}'' is not final.", new Object[]{varName});
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolationWithMessage(data, variableDeclaratorId, "Variables should start with a lowercase character, ''{0}'' starts with uppercase character.", new Object[]{varName});
            }
        }
        return data;
    }

    private String normalizeVariableName(String varName, String[] prefixes, String[] suffixes) {
        return this.stripSuffix(this.stripPrefix(varName, prefixes), suffixes);
    }

    private String stripSuffix(String varName, String[] suffixes) {
        if (suffixes != null) {
            for (int i = 0; i < suffixes.length; ++i) {
                if (!varName.endsWith(suffixes[i])) continue;
                varName = varName.substring(0, varName.length() - suffixes[i].length());
                break;
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, String[] prefixes) {
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                if (!varName.startsWith(prefixes[i])) continue;
                return varName.substring(prefixes[i].length());
            }
        }
        return varName;
    }

    public boolean hasPrefixesOrSuffixes() {
        for (PropertyDescriptor<?> desc : this.getPropertyDescriptors()) {
            Object[] values;
            if (!(desc instanceof StringMultiProperty) || !CollectionUtil.isNotEmpty(values = this.getProperty((StringMultiProperty)desc))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String dysfunctionReason() {
        return this.hasPrefixesOrSuffixes() ? null : "No prefixes or suffixes specified";
    }
}

