/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.optimizations;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class RedundantFieldInitializerRule
extends AbstractJavaRule {
    public RedundantFieldInitializerRule() {
        this.addRuleChainVisit(ASTFieldDeclaration.class);
    }

    @Override
    public Object visit(ASTFieldDeclaration fieldDeclaration, Object data) {
        if (fieldDeclaration.isFinal()) {
            return data;
        }
        for (ASTVariableDeclarator variableDeclarator : fieldDeclaration.findChildrenOfType(ASTVariableDeclarator.class)) {
            Node primaryPrefix;
            Node primaryExpression;
            Node expression;
            Node variableInitializer;
            if (variableDeclarator.jjtGetNumChildren() <= 1 || !((variableInitializer = variableDeclarator.jjtGetChild(1)).jjtGetChild(0) instanceof ASTExpression) || (expression = variableInitializer.jjtGetChild(0)).jjtGetNumChildren() != 1) continue;
            if (expression.jjtGetChild(0) instanceof ASTPrimaryExpression) {
                primaryExpression = expression.jjtGetChild(0);
            } else {
                if (!(expression.jjtGetChild(0) instanceof ASTCastExpression) || !(expression.jjtGetChild(0).jjtGetChild(1) instanceof ASTPrimaryExpression)) continue;
                primaryExpression = expression.jjtGetChild(0).jjtGetChild(1);
            }
            if ((primaryPrefix = primaryExpression.jjtGetChild(0)).jjtGetNumChildren() != 1 || !(primaryPrefix.jjtGetChild(0) instanceof ASTLiteral)) continue;
            ASTLiteral literal = (ASTLiteral)primaryPrefix.jjtGetChild(0);
            if (this.isRef(fieldDeclaration, variableDeclarator)) {
                if (literal.jjtGetNumChildren() != 1 || !(literal.jjtGetChild(0) instanceof ASTNullLiteral)) continue;
                this.addViolation(data, variableDeclarator);
                continue;
            }
            if (literal.jjtGetNumChildren() == 1 && literal.jjtGetChild(0) instanceof ASTBooleanLiteral) {
                ASTBooleanLiteral booleanLiteral = (ASTBooleanLiteral)literal.jjtGetChild(0);
                if (booleanLiteral.isTrue()) continue;
                this.addViolation(data, variableDeclarator);
                continue;
            }
            if (literal.jjtGetNumChildren() != 0) continue;
            double value = -1.0;
            if (literal.isIntLiteral()) {
                String s = literal.getImage();
                if (s.endsWith("l") || s.endsWith("L")) {
                    s = s.substring(0, s.length() - 1);
                }
                value = Long.decode(s).doubleValue();
            } else if (literal.isFloatLiteral()) {
                value = Double.parseDouble(literal.getImage());
            } else if (literal.isCharLiteral()) {
                value = literal.getImage().charAt(1);
            }
            if (value != 0.0) continue;
            this.addViolation(data, variableDeclarator);
        }
        return data;
    }

    private boolean isRef(ASTFieldDeclaration fieldDeclaration, ASTVariableDeclarator variableDeclarator) {
        Node type = fieldDeclaration.jjtGetChild(0).jjtGetChild(0);
        if (type instanceof ASTReferenceType) {
            return true;
        }
        return ((ASTVariableDeclaratorId)variableDeclarator.jjtGetChild(0)).isArray();
    }

    private void addViolation(Object data, ASTVariableDeclarator variableDeclarator) {
        super.addViolation(data, (Node)variableDeclarator, variableDeclarator.jjtGetChild(0).getImage());
    }
}

