/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.strings;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;

public class UseStringBufferLengthRule
extends AbstractJavaRule {
    private Set<NameDeclaration> alreadySeen = new HashSet<NameDeclaration>();

    @Override
    public Object visit(ASTMethodDeclaration acu, Object data) {
        this.alreadySeen.clear();
        return super.visit(acu, data);
    }

    @Override
    public Object visit(ASTName decl, Object data) {
        if (!decl.getImage().endsWith("toString")) {
            return data;
        }
        NameDeclaration nd = decl.getNameDeclaration();
        if (nd == null) {
            return data;
        }
        if (this.alreadySeen.contains(nd) || !(nd instanceof TypedNameDeclaration) || nd instanceof TypedNameDeclaration && TypeHelper.isNeither((TypedNameDeclaration)((Object)nd), StringBuffer.class, StringBuilder.class)) {
            return data;
        }
        this.alreadySeen.add(nd);
        if (this.isViolation(decl)) {
            this.addViolation(data, decl);
        }
        return data;
    }

    private boolean isViolation(ASTName decl) {
        Node parent = decl.jjtGetParent().jjtGetParent();
        if (parent.jjtGetNumChildren() == 4 && parent.jjtGetChild(0).getFirstChildOfType(ASTName.class).getImage().endsWith(".toString")) {
            return this.isEqualsViolation(parent) || this.isLengthViolation(parent);
        }
        return false;
    }

    private boolean isEqualsViolation(Node parent) {
        List<ASTArgumentList> argList;
        if (parent.jjtGetChild(2).hasImageEqualTo("equals") && (argList = parent.jjtGetChild(3).findDescendantsOfType(ASTArgumentList.class)).size() == 1) {
            List<ASTLiteral> literals = argList.get(0).findDescendantsOfType(ASTLiteral.class);
            return literals.size() == 1 && literals.get(0).hasImageEqualTo("\"\"");
        }
        return false;
    }

    private boolean isLengthViolation(Node parent) {
        return parent.jjtGetChild(2).hasImageEqualTo("length");
    }
}

