/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.sunsecure;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.sunsecure.AbstractSunSecureRule;

public class ArrayIsStoredDirectlyRule
extends AbstractSunSecureRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        ASTFormalParameter[] arrs = this.getArrays(node.getParameters());
        if (arrs != null) {
            List<ASTBlockStatement> bs = node.findDescendantsOfType(ASTBlockStatement.class);
            this.checkAll(data, arrs, bs);
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTFormalParameters params = node.getFirstDescendantOfType(ASTFormalParameters.class);
        ASTFormalParameter[] arrs = this.getArrays(params);
        if (arrs != null) {
            this.checkAll(data, arrs, node.findDescendantsOfType(ASTBlockStatement.class));
        }
        return data;
    }

    private void checkAll(Object context, ASTFormalParameter[] arrs, List<ASTBlockStatement> bs) {
        for (ASTFormalParameter element : arrs) {
            this.checkForDirectAssignment(context, element, bs);
        }
    }

    private String getExpressionVarName(Node e) {
        ASTPrimarySuffix suffix;
        String assignedVar = this.getFirstNameImage(e);
        if (assignedVar == null && (suffix = e.getFirstDescendantOfType(ASTPrimarySuffix.class)) != null) {
            assignedVar = suffix.getImage();
            ASTPrimaryPrefix prefix = e.getFirstDescendantOfType(ASTPrimaryPrefix.class);
            if (prefix != null) {
                if (prefix.usesThisModifier()) {
                    assignedVar = "this." + assignedVar;
                } else if (prefix.usesSuperModifier()) {
                    assignedVar = "super." + assignedVar;
                }
            }
        }
        return assignedVar;
    }

    private boolean checkForDirectAssignment(Object ctx, ASTFormalParameter parameter, List<ASTBlockStatement> bs) {
        ASTVariableDeclaratorId vid = parameter.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        String varName = vid.getImage();
        for (ASTBlockStatement b : bs) {
            ASTPrimarySuffix foo;
            String val;
            ASTExpression e;
            Node n;
            ASTPrimaryExpression pe;
            String assignedVar;
            ASTStatementExpression se;
            if (!b.hasDescendantOfType(ASTAssignmentOperator.class) || (se = b.getFirstDescendantOfType(ASTStatementExpression.class)) == null || !(se.jjtGetChild(0) instanceof ASTPrimaryExpression) || (assignedVar = this.getExpressionVarName(pe = (ASTPrimaryExpression)se.jjtGetChild(0))) == null || (n = (Node)pe.getFirstParentOfType(ASTMethodDeclaration.class)) == null && (n = (Node)pe.getFirstParentOfType(ASTConstructorDeclaration.class)) == null || this.isLocalVariable(assignedVar, n) || se.jjtGetNumChildren() < 3 || (e = (ASTExpression)se.jjtGetChild(2)).hasDescendantOfType(ASTEqualityExpression.class) || (val = this.getExpressionVarName(e)) == null || (foo = se.getFirstDescendantOfType(ASTPrimarySuffix.class)) != null && foo.isArrayDereference() || !val.equals(varName)) continue;
            Node md = parameter.getFirstParentOfType(ASTMethodDeclaration.class);
            if (md == null) {
                md = pe.getFirstParentOfType(ASTConstructorDeclaration.class);
            }
            if (this.isLocalVariable(varName, md)) continue;
            this.addViolation(ctx, (Node)parameter, varName);
        }
        return false;
    }

    private final ASTFormalParameter[] getArrays(ASTFormalParameters params) {
        List<ASTFormalParameter> l = params.findChildrenOfType(ASTFormalParameter.class);
        if (l != null && !l.isEmpty()) {
            ArrayList<ASTFormalParameter> l2 = new ArrayList<ASTFormalParameter>();
            for (ASTFormalParameter fp : l) {
                if (!fp.isArray()) continue;
                l2.add(fp);
            }
            return l2.toArray(new ASTFormalParameter[l2.size()]);
        }
        return null;
    }
}

